/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BaseBuildMode;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

public abstract class TwoClicksBuildMode
extends BaseBuildMode {
    protected BlockEntry firstBlockEntry;

    @Override
    public void initialize() {
        super.initialize();
        this.firstBlockEntry = null;
    }

    @Override
    public boolean onClick(BlockSet blocks) {
        super.onClick(blocks);
        if (this.clicks == 1) {
            this.firstBlockEntry = EffortlessBuildingClient.BUILDER_CHAIN.getStartPos();
            if (this.firstBlockEntry == null) {
                this.clicks = 0;
            }
        } else {
            this.clicks = 0;
            return true;
        }
        return false;
    }

    @Override
    public void findCoordinates(BlockSet blocks) {
        if (this.clicks == 0) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos firstPos = this.firstBlockEntry.blockPos;
        BlockPos secondPos = this.findSecondPos((Player)player, this.firstBlockEntry.blockPos, true);
        if (secondPos == null) {
            return;
        }
        int axisLimit = EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPerAxis((Player)player);
        int x1 = firstPos.m_123341_();
        int x2 = secondPos.m_123341_();
        int y1 = firstPos.m_123342_();
        int y2 = secondPos.m_123342_();
        int z1 = firstPos.m_123343_();
        int z2 = secondPos.m_123343_();
        if (x2 - x1 >= axisLimit) {
            x2 = x1 + axisLimit - 1;
        }
        if (x1 - x2 >= axisLimit) {
            x2 = x1 - axisLimit + 1;
        }
        if (y2 - y1 >= axisLimit) {
            y2 = y1 + axisLimit - 1;
        }
        if (y1 - y2 >= axisLimit) {
            y2 = y1 - axisLimit + 1;
        }
        if (z2 - z1 >= axisLimit) {
            z2 = z1 + axisLimit - 1;
        }
        if (z1 - z2 >= axisLimit) {
            z2 = z1 - axisLimit + 1;
        }
        blocks.clear();
        for (BlockPos pos : this.getAllBlocks((Player)player, x1, y1, z1, x2, y2, z2)) {
            if (blocks.containsKey(pos)) continue;
            blocks.add(new BlockEntry(pos));
        }
        blocks.firstPos = firstPos;
        blocks.lastPos = secondPos;
    }

    protected abstract BlockPos findSecondPos(Player var1, BlockPos var2, boolean var3);

    protected abstract List<BlockPos> getAllBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

