/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.gui.element;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import nl.requios.effortlessbuilding.create.foundation.gui.ILightingSettings;
import nl.requios.effortlessbuilding.create.foundation.gui.UIRenderHelper;
import nl.requios.effortlessbuilding.create.foundation.gui.element.RenderElement;
import nl.requios.effortlessbuilding.create.foundation.utility.Color;
import nl.requios.effortlessbuilding.create.foundation.utility.VecHelper;

public class GuiGameElement {
    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(ItemLike itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState state) {
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(PartialModel partial) {
        return new GuiBlockPartialRenderBuilder(partial);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.m_76145_().m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(0)));
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public GuiItemRenderBuilder(ItemLike provider) {
            this(new ItemStack(provider));
        }

        @Override
        public void render(PoseStack matrixStack) {
            this.prepareMatrix(matrixStack);
            this.transformMatrix(matrixStack);
            GuiItemRenderBuilder.renderItemIntoGUI(matrixStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(matrixStack);
        }

        public static void renderItemIntoGUI(PoseStack matrixStack, ItemStack stack, boolean useDefaultLighting) {
            boolean flatLighting;
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = renderer.m_174264_(stack, null, null, 0);
            renderer.f_115096_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, (double)(100.0f + renderer.f_115093_));
            matrixStack.m_85837_(8.0, -8.0, 0.0);
            matrixStack.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flatLighting = !bakedModel.m_7547_();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84930_();
            }
            renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, matrixStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            buffer.m_109911_();
            RenderSystem.m_69482_();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84931_();
            }
            matrixStack.m_85849_();
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(BlockState blockstate) {
            super(Minecraft.m_91087_().m_91289_().m_110910_(blockstate), blockstate);
        }

        @Override
        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            if (this.blockState.m_60734_() instanceof BaseFireBlock) {
                Lighting.m_84930_();
                super.renderModel(blockRenderer, buffer, ms);
                Lighting.m_84931_();
                return;
            }
            super.renderModel(blockRenderer, buffer, ms);
            if (this.blockState.m_60819_().m_76178_()) {
                return;
            }
        }
    }

    public static class GuiBlockPartialRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockPartialRenderBuilder(PartialModel partial) {
            super(partial.get(), null);
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected BakedModel blockModel;
        protected BlockState blockState;

        public GuiBlockModelRenderBuilder(BakedModel blockmodel, @Nullable BlockState blockState) {
            this.blockState = blockState == null ? Blocks.f_50016_.m_49966_() : blockState;
            this.blockModel = blockmodel;
        }

        @Override
        public void render(PoseStack matrixStack) {
            this.prepareMatrix(matrixStack);
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher blockRenderer = mc.m_91289_();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            this.transformMatrix(matrixStack);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            this.renderModel(blockRenderer, buffer, matrixStack);
            this.cleanUpMatrix(matrixStack);
        }

        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            if (this.blockState.m_60734_() == Blocks.f_50016_) {
                RenderType renderType = Sheets.m_110792_();
                blockRenderer.m_110937_().renderModel(ms.m_85850_(), buffer.m_6299_(renderType), this.blockState, this.blockModel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelUtil.VIRTUAL_DATA, null);
            } else {
                int color = Minecraft.m_91087_().m_91298_().m_92577_(this.blockState, null, null, 0);
                Color rgb = new Color(color == -1 ? this.color : color);
                for (RenderType chunkType : this.blockModel.getRenderTypes(this.blockState, RandomSource.m_216335_((long)42L), ModelUtil.VIRTUAL_DATA)) {
                    RenderType renderType = RenderTypeHelper.getEntityRenderType((RenderType)chunkType, (boolean)true);
                    blockRenderer.m_110937_().renderModel(ms.m_85850_(), buffer.m_6299_(renderType), this.blockState, this.blockModel, rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), 0xF000F0, OverlayTexture.f_118083_, ModelUtil.VIRTUAL_DATA, chunkType);
                }
            }
            buffer.m_109911_();
        }
    }

    public static abstract class GuiRenderBuilder
    extends RenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected Vec3 rotationOffset = Vec3.f_82478_;
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vec3 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(PoseStack matrixStack) {
            matrixStack.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(matrixStack);
        }

        protected void transformMatrix(PoseStack matrixStack) {
            matrixStack.m_85837_((double)this.x, (double)this.y, (double)this.z);
            matrixStack.m_85841_((float)this.scale, (float)this.scale, (float)this.scale);
            matrixStack.m_85837_(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(matrixStack);
            matrixStack.m_85837_(this.rotationOffset.f_82479_, this.rotationOffset.f_82480_, this.rotationOffset.f_82481_);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)this.zRot));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)this.xRot));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)this.yRot));
            matrixStack.m_85837_(-this.rotationOffset.f_82479_, -this.rotationOffset.f_82480_, -this.rotationOffset.f_82481_);
        }

        protected void cleanUpMatrix(PoseStack matrixStack) {
            matrixStack.m_85849_();
            this.cleanUpLighting(matrixStack);
        }

        protected void prepareLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                Lighting.m_84931_();
            }
        }

        protected void cleanUpLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                Lighting.m_84931_();
            }
        }
    }
}

