/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.networking;

import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.create.foundation.networking.SimplePacketBase;

public interface ISyncPersistentData {
    public void onPersistentDataUpdated();

    public static class PersistentDataPacket
    extends SimplePacketBase {
        private int entityId;
        private Entity entity;
        private CompoundTag readData;

        public PersistentDataPacket(Entity entity) {
            this.entity = entity;
            this.entityId = entity.m_19879_();
        }

        public PersistentDataPacket(FriendlyByteBuf buffer) {
            this.entityId = buffer.readInt();
            this.readData = buffer.m_130260_();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.entityId);
            buffer.m_130079_(this.entity.getPersistentData());
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
                CompoundTag data = entityByID.getPersistentData();
                new HashSet(data.m_128431_()).forEach(arg_0 -> ((CompoundTag)data).m_128473_(arg_0));
                data.m_128391_(this.readData);
                if (!(entityByID instanceof ISyncPersistentData)) {
                    return;
                }
                ((ISyncPersistentData)entityByID).onPersistentDataUpdated();
            });
            context.get().setPacketHandled(true);
        }
    }
}

