/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import nl.requios.effortlessbuilding.create.Create;
import org.jetbrains.annotations.Nullable;

public class CreateRegistry<K, V> {
    private static final List<CreateRegistry<?, ?>> ALL = new ArrayList();
    protected final IForgeRegistry<K> objectRegistry;
    protected final Map<ResourceLocation, V> locationMap = new HashMap<ResourceLocation, V>();
    protected final Map<K, V> objectMap = new IdentityHashMap();
    protected boolean unwrapped = false;

    public CreateRegistry(IForgeRegistry<K> objectRegistry) {
        this.objectRegistry = objectRegistry;
        ALL.add(this);
    }

    public void register(ResourceLocation location, V value) {
        if (!this.unwrapped) {
            this.locationMap.put(location, value);
        } else {
            Object object = this.objectRegistry.getValue(location);
            if (object != null) {
                this.objectMap.put(object, value);
            } else {
                Create.LOGGER.warn("Could not get object for location '" + location + "' in CreateRegistry after unwrapping!");
            }
        }
    }

    public void register(K object, V value) {
        if (this.unwrapped) {
            this.objectMap.put(object, value);
        } else {
            ResourceLocation location = this.objectRegistry.getKey(object);
            if (location != null) {
                this.locationMap.put(location, value);
            } else {
                Create.LOGGER.warn("Could not get location of object '" + object + "' in CreateRegistry before unwrapping!");
            }
        }
    }

    @Nullable
    public V get(ResourceLocation location) {
        if (!this.unwrapped) {
            return this.locationMap.get(location);
        }
        Object object = this.objectRegistry.getValue(location);
        if (object != null) {
            return this.objectMap.get(object);
        }
        Create.LOGGER.warn("Could not get object for location '" + location + "' in CreateRegistry after unwrapping!");
        return null;
    }

    @Nullable
    public V get(K object) {
        if (this.unwrapped) {
            return this.objectMap.get(object);
        }
        ResourceLocation location = this.objectRegistry.getKey(object);
        if (location != null) {
            return this.locationMap.get(location);
        }
        Create.LOGGER.warn("Could not get location of object '" + object + "' in CreateRegistry before unwrapping!");
        return null;
    }

    public boolean isUnwrapped() {
        return this.unwrapped;
    }

    protected void unwrap() {
        for (Map.Entry<ResourceLocation, V> entry : this.locationMap.entrySet()) {
            ResourceLocation location = entry.getKey();
            Object object = this.objectRegistry.getValue(location);
            if (object != null) {
                this.objectMap.put(object, entry.getValue());
                continue;
            }
            Create.LOGGER.warn("Could not get object for location '" + location + "' in CreateRegistry during unwrapping!");
        }
        this.unwrapped = true;
    }

    public static void unwrapAll() {
        for (CreateRegistry<?, ?> registry : ALL) {
            registry.unwrap();
        }
    }
}

