/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.AllGuiTextures;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.ScrollInput;
import nl.requios.effortlessbuilding.gui.buildmodifier.BaseModifierEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;
import nl.requios.effortlessbuilding.gui.elements.LabeledScrollInput;
import nl.requios.effortlessbuilding.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class ArrayEntry
extends BaseModifierEntry<Array> {
    protected Vector<ScrollInput> offsetInputs = new Vector(3);
    protected ScrollInput countInput;

    public ArrayEntry(ModifiersScreen screen, BaseModifier array) {
        super(screen, (Array)array, (Component)Component.m_237113_((String)"Array"), AllGuiTextures.ARRAY_ENTRY);
        int i;
        this.offsetInputs.clear();
        for (i = 0; i < 3; ++i) {
            int index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 18, 18).titled(Component.m_237113_((String)(i == 0 ? "X Offset" : (i == 1 ? "Y Offset" : "Z Offset")))).calling(value -> {
                ((Array)this.modifier).offset = MathHelper.with(((Array)this.modifier).offset, index, value);
                this.onValueChanged();
            });
            scrollInput.setState(MathHelper.get(((Array)this.modifier).offset, index));
            this.offsetInputs.add(scrollInput);
        }
        this.listeners.addAll(this.offsetInputs);
        this.countInput = new LabeledScrollInput(0, 0, 18, 18).withRange(1, 100).titled(Component.m_237113_((String)"Count")).calling(value -> {
            ((Array)this.modifier).count = value;
            this.onValueChanged();
        });
        this.countInput.setState(((Array)this.modifier).count);
        this.listeners.add(this.countInput);
        for (i = 0; i < 3; ++i) {
            this.offsetInputs.get(i).onChanged();
        }
        this.countInput.onChanged();
        this.onValueChanged();
    }

    @Override
    public void m_6311_(PoseStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        for (int i = 0; i < 3; ++i) {
            this.offsetInputs.get((int)i).f_93620_ = this.left + 49 + 20 * i;
            this.offsetInputs.get((int)i).f_93621_ = this.top + 19;
            this.offsetInputs.get(i).m_6305_(ms, mouseX, mouseY, partialTicks);
        }
        this.countInput.f_93620_ = this.left + 49;
        this.countInput.f_93621_ = this.top + 41;
        this.countInput.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.reachLabel.f_93620_ = this.right - 8 - this.getFont().m_92852_((FormattedText)this.reachLabel.text);
        this.reachLabel.f_93621_ = this.top + 24;
        this.reachLabel.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        int currentReach = Math.max(-1, this.getArrayReach());
        int maxReach = EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPerAxis((Player)Minecraft.m_91087_().f_91074_);
        ChatFormatting reachColor = this.isCurrentReachValid(currentReach, maxReach) ? ChatFormatting.GRAY : ChatFormatting.RED;
        String reachText = reachColor + currentReach + ChatFormatting.GRAY + "/" + ChatFormatting.GRAY + maxReach;
        this.reachLabel.text = Component.m_237113_((String)reachText);
    }

    private int getArrayReach() {
        try {
            double x = Math.abs(((Array)this.modifier).offset.m_123341_());
            double y = Math.abs(((Array)this.modifier).offset.m_123342_());
            double z = Math.abs(((Array)this.modifier).offset.m_123343_());
            double largestOffset = Math.max(Math.max(x, y), z);
            return (int)(largestOffset * (double)((Array)this.modifier).count);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isCurrentReachValid(int currentReach, int maxReach) {
        return currentReach <= maxReach && currentReach > -1;
    }
}

