/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.AllGuiTextures;
import nl.requios.effortlessbuilding.AllIcons;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.IconButton;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.ScrollInput;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.gui.buildmodifier.BaseModifierEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;
import nl.requios.effortlessbuilding.gui.elements.LabeledScrollInput;
import nl.requios.effortlessbuilding.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class RadialMirrorEntry
extends BaseModifierEntry<RadialMirror> {
    protected Vector<ScrollInput> positionInputs;
    protected IconButton playerPositionButton;
    protected IconButton toggleOffsetButton;
    protected ScrollInput slicesInput;
    protected IconButton alternateButton;
    protected ScrollInput radiusInput;
    protected IconButton showLinesButton;
    protected IconButton showAreasButton;
    protected DecimalFormat df = new DecimalFormat("#.#");

    public RadialMirrorEntry(ModifiersScreen screen, BaseModifier radialMirror) {
        super(screen, (RadialMirror)radialMirror, (Component)Component.m_237113_((String)"Radial Mirror"), AllGuiTextures.RADIAL_MIRROR_ENTRY);
        this.positionInputs = new Vector();
        for (int i = 0; i < 3; ++i) {
            int index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 36, 18).showControlScrollsSlowerTooltip().titled(Component.m_237113_((String)(i == 0 ? "X Position" : (i == 1 ? "Y Position" : "Z Position")))).format(integer -> Component.m_237113_((String)this.df.format((double)integer.intValue() / 2.0))).withStepFunction(stepContext -> stepContext.shift ? 20 : (stepContext.control ? 1 : 2)).calling(value -> {
                ((RadialMirror)this.modifier).position = MathHelper.with(((RadialMirror)this.modifier).position, index, (double)value.intValue() / 2.0);
                this.onValueChanged();
            });
            scrollInput.setState((int)(MathHelper.get(((RadialMirror)this.modifier).position, index) * 2.0));
            this.positionInputs.add(scrollInput);
        }
        this.listeners.addAll(this.positionInputs);
        this.playerPositionButton = (IconButton)new IconButton(0, 0, AllIcons.I_PLAYER).withCallback(() -> {
            ((RadialMirror)this.modifier).position = Vec3.m_82528_((Vec3i)Minecraft.m_91087_().f_91074_.m_20183_());
            this.onValueChanged();
        });
        this.playerPositionButton.setToolTip((Component)Components.literal("Set to player position"));
        this.listeners.add(this.playerPositionButton);
        this.toggleOffsetButton = (IconButton)new IconButton(0, 0, AllIcons.I_BLOCK_CENTER).withCallback(() -> {
            ((RadialMirror)this.modifier).position = ((RadialMirror)this.modifier).position.f_82479_ == Math.floor(((RadialMirror)this.modifier).position.f_82479_) ? new Vec3(Math.floor(((RadialMirror)this.modifier).position.f_82479_) + 0.5, Math.floor(((RadialMirror)this.modifier).position.f_82480_) + 0.5, Math.floor(((RadialMirror)this.modifier).position.f_82481_) + 0.5) : new Vec3(Math.floor(((RadialMirror)this.modifier).position.f_82479_), Math.floor(((RadialMirror)this.modifier).position.f_82480_), Math.floor(((RadialMirror)this.modifier).position.f_82481_));
            this.onValueChanged();
        });
        this.listeners.add(this.toggleOffsetButton);
        this.slicesInput = new LabeledScrollInput(0, 0, 27, 18).withRange(3, 1000).titled(Component.m_237113_((String)"Slices")).calling(value -> {
            ((RadialMirror)this.modifier).slices = value;
            this.onValueChanged();
        });
        this.slicesInput.setState(((RadialMirror)this.modifier).slices);
        this.listeners.add(this.slicesInput);
        this.alternateButton = (IconButton)new IconButton(0, 0, AllIcons.I_ALTERNATE_OFF).withCallback(() -> {
            ((RadialMirror)this.modifier).alternate = !((RadialMirror)this.modifier).alternate;
            this.onValueChanged();
        });
        this.listeners.add(this.alternateButton);
        this.radiusInput = new LabeledScrollInput(0, 0, 27, 18).withRange(0, EffortlessBuildingClient.POWER_LEVEL.getMaxMirrorRadius((Player)Minecraft.m_91087_().f_91074_)).titled(Minecraft.m_91087_().f_91074_.m_7500_() ? Component.m_237113_((String)"Radius") : Component.m_237113_((String)"Radius. Use Reach Upgrade items to increase maximum.")).calling(value -> {
            ((RadialMirror)this.modifier).radius = value;
            this.onValueChanged();
        });
        this.radiusInput.setState(((RadialMirror)this.modifier).radius);
        this.listeners.add(this.radiusInput);
        this.showLinesButton = (IconButton)new IconButton(0, 0, AllIcons.I_SHOW_LINES).withCallback(() -> {
            ((RadialMirror)this.modifier).drawLines = !((RadialMirror)this.modifier).drawLines;
            this.onValueChanged();
        });
        this.listeners.add(this.showLinesButton);
        this.showAreasButton = (IconButton)new IconButton(0, 0, AllIcons.I_SHOW_AREAS).withCallback(() -> {
            ((RadialMirror)this.modifier).drawPlanes = !((RadialMirror)this.modifier).drawPlanes;
            this.onValueChanged();
        });
        this.listeners.add(this.showAreasButton);
        for (ScrollInput positionInput : this.positionInputs) {
            positionInput.onChanged();
        }
        this.radiusInput.onChanged();
    }

    @Override
    public void m_6311_(PoseStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        for (int i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.f_93620_ = this.left + 49 + 38 * i;
            input.f_93621_ = this.top + 19;
            input.m_6305_(ms, mouseX, mouseY, partialTicks);
        }
        this.playerPositionButton.f_93620_ = this.left + 163;
        this.playerPositionButton.f_93621_ = this.top + 19;
        this.playerPositionButton.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.toggleOffsetButton.f_93620_ = this.left + 183;
        this.toggleOffsetButton.f_93621_ = this.top + 19;
        this.toggleOffsetButton.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.slicesInput.f_93620_ = this.left + 49;
        this.slicesInput.f_93621_ = this.top + 41;
        this.slicesInput.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.alternateButton.f_93620_ = this.left + 78;
        this.alternateButton.f_93621_ = this.top + 41;
        this.alternateButton.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.radiusInput.f_93620_ = this.left + 134;
        this.radiusInput.f_93621_ = this.top + 41;
        this.radiusInput.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.showLinesButton.f_93620_ = this.left + 163;
        this.showLinesButton.f_93621_ = this.top + 41;
        this.showLinesButton.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.showAreasButton.f_93620_ = this.left + 183;
        this.showAreasButton.f_93621_ = this.top + 41;
        this.showAreasButton.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        for (int i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setState((int)(MathHelper.get(((RadialMirror)this.modifier).position, i) * 2.0));
        }
        if (((RadialMirror)this.modifier).position.f_82479_ == Math.floor(((RadialMirror)this.modifier).position.f_82479_)) {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CENTER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to center of block, for uneven numbered builds."));
        } else {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CORNER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to corner of block, for even numbered builds."));
        }
        if (((RadialMirror)this.modifier).alternate) {
            this.alternateButton.setIcon(AllIcons.I_ALTERNATE_ON);
            this.alternateButton.setToolTip((Component)Components.literal("Alternating the direction of every other slice."));
        } else {
            this.alternateButton.setIcon(AllIcons.I_ALTERNATE_OFF);
            this.alternateButton.setToolTip((Component)Components.literal("Alternate the direction of every other slice. Currently off."));
        }
        if (((RadialMirror)this.modifier).drawLines) {
            this.showLinesButton.setIcon(AllIcons.I_SHOW_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        } else {
            this.showLinesButton.setIcon(AllIcons.I_HIDE_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        }
        if (((RadialMirror)this.modifier).drawPlanes) {
            this.showAreasButton.setIcon(AllIcons.I_SHOW_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        } else {
            this.showAreasButton.setIcon(AllIcons.I_HIDE_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        }
    }
}

