/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;

public class PowerLevelPacket {
    private int powerLevel;

    public PowerLevelPacket() {
    }

    public PowerLevelPacket(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    public static void encode(PowerLevelPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.powerLevel);
    }

    public static PowerLevelPacket decode(FriendlyByteBuf buf) {
        return new PowerLevelPacket(buf.readInt());
    }

    public static class Handler {
        public static void handle(PowerLevelPacket message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    EffortlessBuilding.SERVER_POWER_LEVEL.setPowerLevel((Player)player, message.powerLevel);
                });
            } else {
                ctx.get().enqueueWork(() -> EffortlessBuildingClient.POWER_LEVEL.setPowerLevel(message.powerLevel));
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

