/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.network.IsQuickReplacingPacket;
import nl.requios.effortlessbuilding.network.PacketHandler;

@OnlyIn(value=Dist.CLIENT)
public class BuildSettings {
    private ReplaceMode replaceMode = ReplaceMode.ONLY_AIR;
    private boolean protectTileEntities = true;

    public boolean isQuickReplacing() {
        return this.getReplaceMode() != ReplaceMode.ONLY_AIR;
    }

    public void setReplaceMode(ReplaceMode replaceMode) {
        this.replaceMode = replaceMode;
        PacketHandler.INSTANCE.sendToServer((Object)new IsQuickReplacingPacket(this.isQuickReplacing()));
    }

    public ReplaceMode getReplaceMode() {
        if (!this.canReplaceBlocks()) {
            return ReplaceMode.ONLY_AIR;
        }
        return this.replaceMode;
    }

    public ModeOptions.ActionEnum getReplaceModeActionEnum() {
        return switch (this.getReplaceMode()) {
            default -> throw new IncompatibleClassChangeError();
            case ReplaceMode.ONLY_AIR -> ModeOptions.ActionEnum.REPLACE_ONLY_AIR;
            case ReplaceMode.BLOCKS_AND_AIR -> ModeOptions.ActionEnum.REPLACE_BLOCKS_AND_AIR;
            case ReplaceMode.ONLY_BLOCKS -> ModeOptions.ActionEnum.REPLACE_ONLY_BLOCKS;
            case ReplaceMode.FILTERED_BY_OFFHAND -> ModeOptions.ActionEnum.REPLACE_FILTERED_BY_OFFHAND;
        };
    }

    public void toggleProtectTileEntities() {
        this.protectTileEntities = !this.protectTileEntities;
    }

    public boolean shouldReplaceAir() {
        return this.getReplaceMode() == ReplaceMode.ONLY_AIR || this.getReplaceMode() == ReplaceMode.BLOCKS_AND_AIR;
    }

    public boolean shouldReplaceBlocks() {
        return this.getReplaceMode() == ReplaceMode.ONLY_BLOCKS || this.getReplaceMode() == ReplaceMode.BLOCKS_AND_AIR;
    }

    public boolean shouldReplaceFiltered() {
        return this.getReplaceMode() == ReplaceMode.FILTERED_BY_OFFHAND;
    }

    public boolean shouldProtectTileEntities() {
        return this.protectTileEntities;
    }

    public boolean shouldOffsetStartPosition() {
        return this.getReplaceMode() != ReplaceMode.ONLY_AIR;
    }

    private boolean canReplaceBlocks() {
        return Minecraft.m_91087_().f_91074_ != null && EffortlessBuildingClient.POWER_LEVEL.canReplaceBlocks((Player)Minecraft.m_91087_().f_91074_);
    }

    public static enum ReplaceMode {
        ONLY_AIR,
        BLOCKS_AND_AIR,
        ONLY_BLOCKS,
        FILTERED_BY_OFFHAND;

    }
}

