/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.PowerLevelPacket;

@OnlyIn(value=Dist.CLIENT)
public class PowerLevel {
    private int powerLevel;

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getNextPowerLevel() {
        return Math.min(this.powerLevel + 1, 3);
    }

    public void setPowerLevel(int powerLevel) {
        this.powerLevel = powerLevel;
        EffortlessBuildingClient.BUILD_MODIFIERS.onPowerLevelChanged(powerLevel);
    }

    public boolean canIncreasePowerLevel() {
        return this.getPowerLevel() < 3;
    }

    public void increasePowerLevel() {
        if (this.canIncreasePowerLevel()) {
            this.setPowerLevel(this.getPowerLevel() + 1);
            PacketHandler.INSTANCE.sendToServer((Object)new PowerLevelPacket(this.powerLevel));
        }
    }

    @Deprecated
    public int getMaxReach(Player player) {
        return this.getPlacementReach(player);
    }

    public int getPlacementReach(Player player) {
        return this.getPlacementReach(player, false);
    }

    public int getPlacementReach(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.reach.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.reach.level1.get();
            case 2 -> (Integer)CommonConfig.reach.level2.get();
            case 3 -> (Integer)CommonConfig.reach.level3.get();
            default -> (Integer)CommonConfig.reach.level0.get();
        };
    }

    public int getBuildModeReach(Player player) {
        return this.getPlacementReach(player) + 6;
    }

    public int getMaxBlocksPlacedAtOnce(Player player) {
        return this.getMaxBlocksPlacedAtOnce(player, false);
    }

    public int getMaxBlocksPlacedAtOnce(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxBlocksPlacedAtOnce.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level0.get();
        };
    }

    public int getMaxBlocksPerAxis(Player player) {
        return this.getMaxBlocksPerAxis(player, false);
    }

    public int getMaxBlocksPerAxis(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxBlocksPerAxis.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPerAxis.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPerAxis.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPerAxis.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPerAxis.level0.get();
        };
    }

    public int getMaxMirrorRadius(Player player) {
        return this.getMaxMirrorRadius(player, false);
    }

    public int getMaxMirrorRadius(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxMirrorRadius.creative.get();
        }
        return switch (this.getPowerLevel() + (nextPowerLevel ? 1 : 0)) {
            case 1 -> (Integer)CommonConfig.maxMirrorRadius.level1.get();
            case 2 -> (Integer)CommonConfig.maxMirrorRadius.level2.get();
            case 3 -> (Integer)CommonConfig.maxMirrorRadius.level3.get();
            default -> (Integer)CommonConfig.maxMirrorRadius.level0.get();
        };
    }

    public boolean isDisabled(Player player) {
        return this.getMaxBlocksPlacedAtOnce(player) <= 0 || this.getMaxBlocksPerAxis(player) <= 0;
    }

    public boolean canBreakFar(Player player) {
        return player.m_7500_();
    }

    public boolean canReplaceBlocks(Player player) {
        return player.m_7500_();
    }
}

