/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.capability.IPowerLevel;
import nl.requios.effortlessbuilding.capability.PowerLevelCapability;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.network.ModifierSettingsPacket;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.PowerLevelPacket;
import nl.requios.effortlessbuilding.systems.ServerBuildState;
import nl.requios.effortlessbuilding.utilities.PowerLevelCommand;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PowerLevelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        EffortlessBuilding.SERVER_BLOCK_PLACER.tick();
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        if (EffortlessBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        if (!ServerBuildState.isLikeVanilla(player) && CommonEvents.isPlayerHoldingBlock(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        if (EffortlessBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        IPowerLevel powerLevel = (IPowerLevel)player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerLevel == null) {
            return;
        }
        if (!ServerBuildState.isLikeVanilla(player) && powerLevel.canBreakFar(player)) {
            event.setCanceled(true);
        }
    }

    private static boolean isPlayerHoldingBlock(Player player) {
        ItemStack currentItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        return currentItemStack.m_41720_() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.m_6144_();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            return;
        }
        ServerBuildState.handleNewPlayer(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ModifierSettingsPacket(player));
        IPowerLevel powerLevel = (IPowerLevel)player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerLevel == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PowerLevelPacket(powerLevel.getPowerLevel()));
    }

    @SubscribeEvent
    public static void registerCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(CapabilityHandler.POWER_LEVEL_CAP, (ICapabilityProvider)new PowerLevelCapability());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).ifPresent(dataOriginal -> clone.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).ifPresent(dataClone -> dataClone.setPowerLevel(dataOriginal.getPowerLevel())));
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            EffortlessBuilding.log("PlayerLoggedOutEvent triggers on client side");
            return;
        }
        EffortlessBuilding.UNDO_REDO.clear(player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            EffortlessBuilding.log("PlayerRespawnEvent triggers on client side");
            return;
        }
        ServerBuildState.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            EffortlessBuilding.log("PlayerChangedDimensionEvent triggers on client side");
            return;
        }
        EffortlessBuilding.UNDO_REDO.clear(player);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
    }
}

