/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nl.requios.effortlessbuilding.ClientConfig;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.ServerConfig;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.DiamondRandomizerBagContainer;
import nl.requios.effortlessbuilding.gui.GoldenRandomizerBagContainer;
import nl.requios.effortlessbuilding.gui.RandomizerBagContainer;
import nl.requios.effortlessbuilding.item.DiamondRandomizerBagItem;
import nl.requios.effortlessbuilding.item.GoldenRandomizerBagItem;
import nl.requios.effortlessbuilding.item.PowerLevelItem;
import nl.requios.effortlessbuilding.item.RandomizerBagItem;
import nl.requios.effortlessbuilding.item.ReachUpgrade1Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade2Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade3Item;
import nl.requios.effortlessbuilding.item.SingleItemLootModifier;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.proxy.IProxy;
import nl.requios.effortlessbuilding.proxy.ServerProxy;
import nl.requios.effortlessbuilding.systems.ItemUsageTracker;
import nl.requios.effortlessbuilding.systems.ServerBlockPlacer;
import nl.requios.effortlessbuilding.systems.UndoRedo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="effortlessbuilding")
public class EffortlessBuilding {
    public static final String MODID = "effortlessbuilding";
    public static final Logger logger = LogManager.getLogger();
    public static EffortlessBuilding instance;
    public static IProxy proxy;
    public static final ServerBlockPlacer SERVER_BLOCK_PLACER;
    public static final UndoRedo UNDO_REDO;
    public static final ItemUsageTracker ITEM_USAGE_TRACKER;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS;
    public static final RegistryObject<Item> RANDOMIZER_BAG_ITEM;
    public static final RegistryObject<Item> GOLDEN_RANDOMIZER_BAG_ITEM;
    public static final RegistryObject<Item> DIAMOND_RANDOMIZER_BAG_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_1_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_2_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_3_ITEM;
    public static final RegistryObject<Item> MUSCLES_ITEM;
    public static final RegistryObject<Item> ELASTIC_HAND_ITEM;
    public static final RegistryObject<Item> BUILDING_TECHNIQUES_BOOK_ITEM;
    public static final RegistryObject<MenuType<RandomizerBagContainer>> RANDOMIZER_BAG_CONTAINER;
    public static final RegistryObject<MenuType<GoldenRandomizerBagContainer>> GOLDEN_RANDOMIZER_BAG_CONTAINER;
    public static final RegistryObject<MenuType<DiamondRandomizerBagContainer>> DIAMOND_RANDOMIZER_BAG_CONTAINER;

    public EffortlessBuilding() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(EffortlessBuilding::setup);
        modEventBus.addListener(EffortlessBuilding::addTabContents);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EffortlessBuildingClient.onConstructorClient(modEventBus, forgeEventBus));
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        RegistryObject<Codec<SingleItemLootModifier>> singleItemLootModifier = SingleItemLootModifier.CODEC;
        LOOT_MODIFIERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.spec);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.spec);
    }

    public static void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        CompatHelper.setup();
    }

    public static void addTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            event.m_246601_(stacks);
        }
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerContainer(IContainerFactory<T> fact) {
        MenuType type = new MenuType(fact, FeatureFlags.f_244280_.m_247355_());
        return type;
    }

    public static void log(String msg) {
        logger.info(msg);
    }

    public static void log(Player player, String msg) {
        EffortlessBuilding.log(player, msg, false);
    }

    public static void log(Player player, String msg, boolean actionBar) {
        player.m_5661_((Component)Component.m_237113_((String)msg), actionBar);
    }

    public static void logTranslate(Player player, String prefix, String translationKey, String suffix, boolean actionBar) {
        proxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    static {
        proxy = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        SERVER_BLOCK_PLACER = new ServerBlockPlacer();
        UNDO_REDO = new UndoRedo();
        ITEM_USAGE_TRACKER = new ItemUsageTracker();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MODID);
        RANDOMIZER_BAG_ITEM = ITEMS.register("randomizer_bag", RandomizerBagItem::new);
        GOLDEN_RANDOMIZER_BAG_ITEM = ITEMS.register("golden_randomizer_bag", GoldenRandomizerBagItem::new);
        DIAMOND_RANDOMIZER_BAG_ITEM = ITEMS.register("diamond_randomizer_bag", DiamondRandomizerBagItem::new);
        REACH_UPGRADE_1_ITEM = ITEMS.register("reach_upgrade1", ReachUpgrade1Item::new);
        REACH_UPGRADE_2_ITEM = ITEMS.register("reach_upgrade2", ReachUpgrade2Item::new);
        REACH_UPGRADE_3_ITEM = ITEMS.register("reach_upgrade3", ReachUpgrade3Item::new);
        MUSCLES_ITEM = ITEMS.register("muscles", PowerLevelItem::new);
        ELASTIC_HAND_ITEM = ITEMS.register("elastic_hand", PowerLevelItem::new);
        BUILDING_TECHNIQUES_BOOK_ITEM = ITEMS.register("building_techniques_book", PowerLevelItem::new);
        RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("randomizer_bag", () -> EffortlessBuilding.registerContainer(RandomizerBagContainer::new));
        GOLDEN_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("golden_randomizer_bag", () -> EffortlessBuilding.registerContainer(GoldenRandomizerBagContainer::new));
        DIAMOND_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("diamond_randomizer_bag", () -> EffortlessBuilding.registerContainer(DiamondRandomizerBagContainer::new));
    }
}

