/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final Validation validation = new Validation(builder);
    public static final Memory memory = new Memory(builder);
    public static final ForgeConfigSpec spec = builder.build();

    public static class Validation {
        public final ForgeConfigSpec.BooleanValue allowInSurvival;
        public final ForgeConfigSpec.BooleanValue useWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.IntValue maxBlocksPlacedAtOnce;

        public Validation(ForgeConfigSpec.Builder builder) {
            builder.push("Validation");
            this.allowInSurvival = builder.comment("Allow use of the mod for players that are in survival mode. Otherwise, only creative mode players can use the mod.").define("allowInSurvival", true);
            this.useWhitelist = builder.comment("Use a whitelist to determine which players can use the mod. If false, all players can use the mod.").define("useWhitelist", false);
            this.whitelist = builder.comment("List of player names that can use the mod.").defineList("whitelist", Arrays.asList("Player1", "Player2"), o -> true);
            this.maxBlocksPlacedAtOnce = builder.comment("Maximum number of blocks that can be placed at once. This is a last check. If you want the player to receive visual feedback instead of an error message, change values in the common config.").defineInRange("maxBlocksPlacedAtOnce", 10000, 1, 100000);
            builder.pop();
        }
    }

    public static class Memory {
        public final ForgeConfigSpec.IntValue undoStackSize;

        public Memory(ForgeConfigSpec.Builder builder) {
            builder.push("Memory");
            this.undoStackSize = builder.comment("How many sets of blocks are remembered for the undo functionality, per player.").worldRestart().defineInRange("undoStackSize", 50, 10, 200);
            builder.pop();
        }
    }
}

