/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.capability.IPowerLevel;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.PowerLevelPacket;

public class PowerLevelCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"powerlevel").requires(cs -> cs.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"query").executes(ctx -> {
            PowerLevelCommand.logPowerLevel((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_());
            return 0;
        })).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            PowerLevelCommand.logPowerLevel((CommandSourceStack)ctx.getSource(), (Player)player);
            return 0;
        })))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> {
            PowerLevelCommand.setPowerLevel((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), (Integer)ctx.getArgument("value", Integer.class));
            return 0;
        })))));
    }

    private static void logPowerLevel(CommandSourceStack source, Player player) {
        int powerLevel = CapabilityHandler.getPowerLevel(player);
        source.m_288197_(() -> Component.m_237110_((String)"effortlessbuilding.commands.powerlevel", (Object[])new Object[]{player.m_5446_(), powerLevel}), false);
    }

    private static void setPowerLevel(CommandSourceStack source, Player player, int powerLevel) throws CommandSyntaxException {
        IPowerLevel powerCap = (IPowerLevel)player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerCap == null) {
            return;
        }
        powerCap.setPowerLevel(powerLevel);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PowerLevelPacket(powerLevel));
        source.m_288197_(() -> Component.m_237110_((String)"effortlessbuilding.commands.powerlevel.success", (Object[])new Object[]{player.m_5446_(), powerLevel}), true);
    }
}

