/*
 * Decompiled with CFR 0.152.
 */
package elvenation;

import elvenation.ElvenationMod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class ElvenationModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public ElvenationModElements() {
        sounds.put(new ResourceLocation("elvenation", "elvenation"), new SoundEvent(new ResourceLocation("elvenation", "elvenation")));
        sounds.put(new ResourceLocation("elvenation", "elf.idle"), new SoundEvent(new ResourceLocation("elvenation", "elf.idle")));
        sounds.put(new ResourceLocation("elvenation", "elf.pleased"), new SoundEvent(new ResourceLocation("elvenation", "elf.pleased")));
        sounds.put(new ResourceLocation("elvenation", "elf.hurt"), new SoundEvent(new ResourceLocation("elvenation", "elf.hurt")));
        sounds.put(new ResourceLocation("elvenation", "elf.death"), new SoundEvent(new ResourceLocation("elvenation", "elf.death")));
        sounds.put(new ResourceLocation("elvenation", "grumpy.elf.idle"), new SoundEvent(new ResourceLocation("elvenation", "grumpy.elf.idle")));
        sounds.put(new ResourceLocation("elvenation", "grumpy.elf.dies"), new SoundEvent(new ResourceLocation("elvenation", "grumpy.elf.dies")));
        sounds.put(new ResourceLocation("elvenation", "grumpy.elf.hurt"), new SoundEvent(new ResourceLocation("elvenation", "grumpy.elf.hurt")));
        sounds.put(new ResourceLocation("elvenation", "grumpy.elf.pleased"), new SoundEvent(new ResourceLocation("elvenation", "grumpy.elf.pleased")));
        sounds.put(new ResourceLocation("elvenation", "money"), new SoundEvent(new ResourceLocation("elvenation", "money")));
        sounds.put(new ResourceLocation("elvenation", "zap"), new SoundEvent(new ResourceLocation("elvenation", "zap")));
        sounds.put(new ResourceLocation("elvenation", "magic_broth.music"), new SoundEvent(new ResourceLocation("elvenation", "magic_broth.music")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("elvenation").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        ElvenationMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final ElvenationModElements elements;
        protected final int sortid;

        public ModElement(ElvenationModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

