/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable;

import com.mrcrayfish.enchantable.core.ModEnchantments;
import com.mrcrayfish.enchantable.event.EditBlockEvent;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="enchantable")
public class Enchantable {
    public static final EnchantmentType HOE = EnchantmentType.create((String)"enchantable:hoe", item -> item.getItem() instanceof HoeItem);
    public static final EnchantmentType TILLABLE = EnchantmentType.create((String)"enchantable:tillable", item -> item.getItem() instanceof HoeItem || item.getItem() instanceof ShovelItem);
    public static final EnchantmentType PICKAXE = EnchantmentType.create((String)"enchantable:pickaxe", item -> item.getItem() instanceof PickaxeItem);

    public Enchantable() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEnchantments.REGISTER.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addEnchantmentTypesToGroup(ItemGroup.field_78040_i, HOE, TILLABLE, PICKAXE);
    }

    private void addEnchantmentTypesToGroup(ItemGroup group, EnchantmentType ... types) {
        EnchantmentType[] oldTypes = group.func_111225_m();
        EnchantmentType[] newTypes = new EnchantmentType[oldTypes.length + types.length];
        System.arraycopy(oldTypes, 0, newTypes, 0, oldTypes.length);
        System.arraycopy(types, 0, newTypes, oldTypes.length, types.length);
        group.func_111229_a(newTypes);
    }

    @SubscribeEvent
    public void canPlayerEditBlock(EditBlockEvent event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() instanceof CropsBlock) {
            ItemStack heldItem = event.getPlayer().func_184614_ca();
            if (heldItem.func_190926_b()) {
                return;
            }
            if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.SEEDER.get()) && !EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.CULTIVATOR.get())) {
                return;
            }
            CropsBlock crop = (CropsBlock)state.func_177230_c();
            if (((Integer)state.func_177229_b((IProperty)crop.func_185524_e())).intValue() != crop.func_185526_g()) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean fireEditBlockEvent(PlayerEntity player, World world, BlockPos pos) {
        return MinecraftForge.EVENT_BUS.post((Event)new EditBlockEvent(player, world, pos));
    }
}

