/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.client;

import com.google.common.collect.Sets;
import com.mrcrayfish.enchantable.Enchantable;
import com.mrcrayfish.enchantable.core.ModEnchantments;
import com.mrcrayfish.enchantable.enchantment.ExcavatorEnchantment;
import com.mrcrayfish.enchantable.enchantment.OreEaterEnchantment;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enchantable", value={Dist.CLIENT})
public class ClientEvents {
    private static boolean needsResetting = true;
    private static BlockPos lastHittingPos = null;
    private static final Long2ObjectMap<DestroyBlockProgress> DAMAGE_PROGRESS = new Long2ObjectOpenHashMap();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            if (mc.field_71439_g != null) {
                BlockRayTraceResult result;
                BlockPos pos;
                boolean leftClicking;
                boolean bl = leftClicking = mc.field_71462_r == null && mc.field_71474_y.field_74312_F.func_151470_d() && mc.field_71417_B.func_198035_h();
                if (leftClicking && mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && !Enchantable.fireEditBlockEvent((PlayerEntity)mc.field_71439_g, (World)mc.field_71441_e, pos = (result = (BlockRayTraceResult)mc.field_71476_x).func_216350_a())) {
                    needsResetting = true;
                    return;
                }
                if (needsResetting) {
                    ClientEvents.resetBreakParticles();
                    needsResetting = false;
                }
            }
        } else if (mc.field_71442_b != null) {
            BlockState blockState;
            if (!mc.field_71442_b.field_78778_j) {
                ClientEvents.clearBreakProgress();
                return;
            }
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                ClientEvents.clearBreakProgress();
                return;
            }
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_190926_b()) {
                ClientEvents.clearBreakProgress();
                return;
            }
            World world = player.field_70170_p;
            BlockPos pos = mc.field_71442_b.field_178895_c;
            Direction direction = Direction.func_196054_a((Entity)player)[0];
            double reach = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
            RayTraceResult result = player.func_213324_a(reach, 0.0f, false);
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
                direction = blockResult.func_216354_b();
            }
            if (!ForgeHooks.canHarvestBlock((BlockState)(blockState = world.func_180495_p(pos)), (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
                ClientEvents.clearBreakProgress();
                return;
            }
            ClientEvents.clearBreakProgress();
            ClientEvents.handleExcavatorBreakProgress(mc, pos, (PlayerEntity)player, world, heldItem, blockState, direction);
            ClientEvents.handleOreEaterBreakProgress(mc, pos, (PlayerEntity)player, world, heldItem, blockState);
        }
    }

    private static void handleExcavatorBreakProgress(Minecraft mc, BlockPos pos, PlayerEntity player, World world, ItemStack heldItem, BlockState blockState, Direction direction) {
        Function<Pair<Integer, Integer>, BlockPos> function;
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.EXCAVATOR.get())) {
            return;
        }
        if (blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return;
        }
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.EXCAVATOR.get());
        int size = 3 + Math.max(0, level - 1) * 2;
        if (direction.func_176740_k().func_176722_c()) {
            Direction finalDirection = direction.func_176746_e();
            function = pair -> pos.func_177982_a(finalDirection.func_176740_k().func_196052_a((Integer)pair.getLeft() - (size - 1) / 2, 0, 0), (Integer)pair.getRight() - (size - 1) / 2, finalDirection.func_176740_k().func_196052_a(0, 0, (Integer)pair.getLeft() - (size - 1) / 2));
        } else {
            function = pair -> pos.func_177982_a((Integer)pair.getLeft() - (size - 1) / 2, 0, (Integer)pair.getRight() - (size - 1) / 2);
        }
        DestroyBlockProgress progress = (DestroyBlockProgress)mc.field_71438_f.field_72738_E.get(player.func_145782_y());
        if (progress != null) {
            lastHittingPos = pos;
            Set<BlockPos> blocks = ClientEvents.getExcavatorBlocks(world, size, pos, player, function);
            blocks.forEach(pos1 -> {
                DestroyBlockProgress subProgress = new DestroyBlockProgress(player.func_145782_y(), pos1);
                subProgress.func_73107_a(progress.func_73106_e());
                DAMAGE_PROGRESS.put(pos1.func_218275_a(), (Object)subProgress);
                ((SortedSet)mc.field_71438_f.field_228407_B_.computeIfAbsent(pos1.func_218275_a(), value -> Sets.newTreeSet())).add(subProgress);
            });
        }
    }

    private static void handleOreEaterBreakProgress(Minecraft mc, BlockPos pos, PlayerEntity player, World world, ItemStack heldItem, BlockState blockState) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.ORE_EATER.get())) {
            return;
        }
        Set toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        if (!ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, pos)) {
            return;
        }
        if (!blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return;
        }
        DestroyBlockProgress progress = (DestroyBlockProgress)mc.field_71438_f.field_72738_E.get(player.func_145782_y());
        if (progress == null) {
            return;
        }
        Block targetBlock = blockState.func_177230_c();
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.ORE_EATER.get());
        Set<BlockPos> orePositions = OreEaterEnchantment.gatherBlocks(targetBlock, world, pos, 2 + Math.max(0, level - 1) * 2);
        for (BlockPos orePos : orePositions) {
            blockState = world.func_180495_p(orePos);
            if (!ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, orePos)) continue;
            DestroyBlockProgress subProgress = new DestroyBlockProgress(player.func_145782_y(), orePos);
            subProgress.func_73107_a(progress.func_73106_e());
            DAMAGE_PROGRESS.put(orePos.func_218275_a(), (Object)subProgress);
            ((SortedSet)mc.field_71438_f.field_228407_B_.computeIfAbsent(orePos.func_218275_a(), value -> Sets.newTreeSet())).add(subProgress);
        }
    }

    private static void clearBreakProgress() {
        if (DAMAGE_PROGRESS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        DAMAGE_PROGRESS.forEach((posLong, destroyBlockProgress) -> {
            Set set = (Set)mc.field_71438_f.field_228407_B_.get(posLong);
            if (set != null) {
                set.remove(destroyBlockProgress);
                if (set.isEmpty()) {
                    mc.field_71438_f.field_228407_B_.remove(posLong);
                }
            }
        });
        DAMAGE_PROGRESS.clear();
    }

    private static Set<BlockPos> getExcavatorBlocks(World world, int size, BlockPos source, PlayerEntity player, Function<Pair<Integer, Integer>, BlockPos> function) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return Collections.emptySet();
        }
        HashSet<ToolType> toolTypes = new HashSet();
        if (heldItem.func_77973_b() instanceof ToolItem) {
            toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                BlockState blockState;
                BlockPos pos = function.apply((Pair<Integer, Integer>)Pair.of((Object)i, (Object)j));
                if (pos.equals((Object)source) || (blockState = world.func_180495_p(pos)).isAir((IBlockReader)world, pos) || !ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, pos) || blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) continue;
                blocks.add(pos);
            }
        }
        return blocks;
    }

    private static void resetBreakParticles() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            BlockPos currentBlock = mc.field_71442_b.field_178895_c;
            BlockState blockstate = mc.field_71441_e.func_180495_p(currentBlock);
            mc.func_193032_ao().func_193294_a(mc.field_71441_e, currentBlock, blockstate, -1.0f);
            mc.field_71439_g.field_71174_a.func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, currentBlock, Direction.DOWN));
            mc.field_71442_b.field_78770_f = 0.0f;
            mc.field_71441_e.func_175715_c(mc.field_71439_g.func_145782_y(), currentBlock, -1);
            mc.field_71442_b.field_78778_j = false;
            mc.field_71439_g.func_184821_cY();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

