/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.enchantment;

import com.mrcrayfish.enchantable.core.ModEnchantments;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enchantable")
public class ExcavatorEnchantment
extends Enchantment {
    public static final int BASE_SIZE = 3;

    public ExcavatorEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.DIGGER, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return super.func_77326_a(enchantment) && enchantment != Enchantments.field_185308_t && enchantment != ModEnchantments.ORE_EATER.get();
    }

    public int func_77325_b() {
        return 2;
    }

    @SubscribeEvent
    public static void onPlayerMineSpeed(PlayerEvent.BreakSpeed event) {
        float effectiveSpeed = ExcavatorEnchantment.getEffectiveDigSpeed(event.getPlayer(), event.getPos());
        if (effectiveSpeed > 0.0f) {
            event.setNewSpeed(effectiveSpeed);
        }
    }

    private static float getEffectiveDigSpeed(PlayerEntity player, BlockPos pos) {
        Function<Pair<Integer, Integer>, BlockPos> function;
        BlockState blockState;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return 0.0f;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.EXCAVATOR.get())) {
            return 0.0f;
        }
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.EXCAVATOR.get());
        int size = 3 + Math.max(0, level - 1) * 2;
        World world = player.func_130014_f_();
        Direction direction = Direction.func_196054_a((Entity)player)[0];
        double reach = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        RayTraceResult result = player.func_213324_a(reach, 0.0f, false);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            direction = blockResult.func_216354_b();
        }
        HashSet<ToolType> toolTypes = new HashSet();
        if (heldItem.func_77973_b() instanceof ToolItem) {
            toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        }
        if (!ForgeHooks.canHarvestBlock((BlockState)(blockState = world.func_180495_p(pos)), (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
            return 0.0f;
        }
        if (blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return 0.0f;
        }
        if (direction.func_176740_k().func_176722_c()) {
            Direction finalDirection = direction.func_176746_e();
            function = pair -> pos.func_177982_a(finalDirection.func_176740_k().func_196052_a((Integer)pair.getLeft() - (size - 1) / 2, 0, 0), (Integer)pair.getRight() - (size - 1) / 2, finalDirection.func_176740_k().func_196052_a(0, 0, (Integer)pair.getLeft() - (size - 1) / 2));
        } else {
            function = pair -> pos.func_177982_a((Integer)pair.getLeft() - (size - 1) / 2, 0, (Integer)pair.getRight() - (size - 1) / 2);
        }
        Pair<Float, Integer> pair2 = ExcavatorEnchantment.getDestroySpeed(world, player, size, toolTypes, heldItem, function);
        float totalDigSpeed = ((Float)pair2.getLeft()).floatValue();
        int totalBlocks = (Integer)pair2.getRight();
        if (totalBlocks <= 0) {
            return 0.0f;
        }
        EffectInstance instance = player.func_70660_b(Effects.field_76422_e);
        if (instance != null) {
            totalDigSpeed *= (float)(instance.func_76458_c() + 1);
        }
        return totalDigSpeed / (float)totalBlocks / (float)totalBlocks;
    }

    private static Pair<Float, Integer> getDestroySpeed(World world, PlayerEntity player, int size, Set<ToolType> toolTypes, ItemStack stack, Function<Pair<Integer, Integer>, BlockPos> function) {
        int durability = stack.func_77958_k() - stack.func_77952_i();
        float totalDigSpeed = 0.0f;
        int totalBlocks = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                BlockPos blockPos = function.apply((Pair<Integer, Integer>)Pair.of((Object)i, (Object)j));
                BlockState blockState = world.func_180495_p(blockPos);
                if (blockState.isAir((IBlockReader)world, blockPos) || !ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, blockPos) || blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) continue;
                totalDigSpeed += ExcavatorEnchantment.getDigSpeed(player, blockState, blockPos);
                if (++totalBlocks < durability) continue;
                return Pair.of((Object)Float.valueOf(totalDigSpeed), (Object)totalBlocks);
            }
        }
        return Pair.of((Object)Float.valueOf(totalDigSpeed), (Object)totalBlocks);
    }

    @SubscribeEvent
    public static void onPlayerBreak(BlockEvent.BreakEvent event) {
        Function<Pair<Integer, Integer>, BlockPos> function;
        BlockState blockState;
        ItemStack heldItem = event.getPlayer().func_184614_ca();
        if (heldItem.func_190926_b()) {
            return;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.EXCAVATOR.get())) {
            return;
        }
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.EXCAVATOR.get());
        int size = 3 + Math.max(0, level - 1) * 2;
        PlayerEntity player = event.getPlayer();
        Direction direction = Direction.func_196054_a((Entity)event.getPlayer())[0];
        double reach = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        RayTraceResult result = player.func_213324_a(reach, 0.0f, false);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            direction = blockResult.func_216354_b();
        }
        World world = event.getPlayer().func_130014_f_();
        BlockPos pos = event.getPos();
        HashSet<ToolType> toolTypes = new HashSet();
        if (heldItem.func_77973_b() instanceof ToolItem) {
            toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        }
        if (!ExcavatorEnchantment.isToolEffective(toolTypes, blockState = world.func_180495_p(pos), player, world, pos)) {
            return;
        }
        if (blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return;
        }
        if (direction.func_176740_k().func_176722_c()) {
            Direction finalDirection = direction.func_176746_e();
            function = pair -> pos.func_177982_a(finalDirection.func_176740_k().func_196052_a((Integer)pair.getLeft() - (size - 1) / 2, 0, 0), (Integer)pair.getRight() - (size - 1) / 2, finalDirection.func_176740_k().func_196052_a(0, 0, (Integer)pair.getLeft() - (size - 1) / 2));
        } else {
            function = pair -> pos.func_177982_a((Integer)pair.getLeft() - (size - 1) / 2, 0, (Integer)pair.getRight() - (size - 1) / 2);
        }
        int durability = heldItem.func_77958_k() - heldItem.func_77952_i();
        if (durability > 1) {
            int damageAmount = ExcavatorEnchantment.destroyBlocks(world, pos, player, size, toolTypes, heldItem, function);
            heldItem.func_222118_a(damageAmount, (LivingEntity)player, player1 -> player1.func_213334_d(Hand.MAIN_HAND));
        }
    }

    private static int destroyBlocks(World world, BlockPos source, PlayerEntity player, int size, Set<ToolType> toolTypes, ItemStack stack, Function<Pair<Integer, Integer>, BlockPos> function) {
        int durability = stack.func_77958_k() - stack.func_77952_i();
        int damageAmount = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                BlockPos newPos = function.apply((Pair<Integer, Integer>)Pair.of((Object)i, (Object)j));
                if (newPos.equals((Object)source)) continue;
                if (ExcavatorEnchantment.destroyBlock(world, toolTypes, newPos, true, stack, player)) {
                    ++damageAmount;
                }
                if (damageAmount < durability) continue;
                return damageAmount;
            }
        }
        return damageAmount;
    }

    private static boolean destroyBlock(World world, Set<ToolType> toolTypes, BlockPos pos, boolean spawnDrops, ItemStack stack, PlayerEntity player) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.isAir((IBlockReader)world, pos)) {
            return false;
        }
        if (ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, pos)) {
            if (blockState.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
                return false;
            }
            IFluidState fluidState = world.func_204610_c(pos);
            if (spawnDrops) {
                TileEntity tileEntity = blockState.hasTileEntity() ? world.func_175625_s(pos) : null;
                Block.func_220054_a((BlockState)blockState, (World)world, (BlockPos)pos, (TileEntity)tileEntity, (Entity)player, (ItemStack)stack);
            }
            return world.func_180501_a(pos, fluidState.func_206883_i(), 3);
        }
        return false;
    }

    public static boolean isToolEffective(Set<ToolType> toolTypes, BlockState state, PlayerEntity player, World world, BlockPos pos) {
        if (toolTypes.stream().noneMatch(toolType -> state.func_177230_c().isToolEffective(state, toolType)) && state.func_185904_a().func_76229_l()) {
            return false;
        }
        return ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos);
    }

    public static float getDigSpeed(PlayerEntity player, BlockState state, @Nullable BlockPos pos) {
        float destroySpeed = player.field_71071_by.func_184438_a(state);
        if (destroySpeed > 1.0f) {
            int efficiencyModifier = EnchantmentHelper.func_185293_e((LivingEntity)player);
            ItemStack heldItem = player.func_184614_ca();
            if (efficiencyModifier > 0 && !heldItem.func_190926_b()) {
                destroySpeed += (float)(efficiencyModifier * efficiencyModifier + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)player)) {
            destroySpeed *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.func_70644_a(Effects.field_76419_f)) {
            float multiplier;
            switch (player.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    multiplier = 0.3f;
                    break;
                }
                case 1: {
                    multiplier = 0.09f;
                    break;
                }
                case 2: {
                    multiplier = 0.0027f;
                    break;
                }
                default: {
                    multiplier = 8.1E-4f;
                }
            }
            destroySpeed *= multiplier;
        }
        if (player.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
            destroySpeed /= 5.0f;
        }
        if (!player.field_70122_E) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }
}

