/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.enchantment;

import com.mrcrayfish.enchantable.Enchantable;
import com.mrcrayfish.enchantable.core.ModEnchantments;
import com.mrcrayfish.enchantable.enchantment.ExcavatorEnchantment;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantable")
public class OreEaterEnchantment
extends Enchantment {
    public OreEaterEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, Enchantable.PICKAXE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return super.func_77326_a(enchantment) && enchantment != ModEnchantments.EXCAVATOR.get();
    }

    @SubscribeEvent
    public static void onPlayerBreak(BlockEvent.BreakEvent event) {
        BlockPos pos;
        ItemStack heldItem = event.getPlayer().func_184614_ca();
        if (heldItem.func_190926_b()) {
            return;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.ORE_EATER.get())) {
            return;
        }
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.ORE_EATER.get());
        PlayerEntity player = event.getPlayer();
        World world = event.getPlayer().func_130014_f_();
        BlockState state = world.func_180495_p(pos = event.getPos());
        if (!state.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return;
        }
        Set<Object> toolTypes = new HashSet<ToolType>();
        if (heldItem.func_77973_b() instanceof ToolItem) {
            toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        }
        if (!ExcavatorEnchantment.isToolEffective(toolTypes, state, player, world, pos)) {
            return;
        }
        int damageAmount = 0;
        int durability = heldItem.func_77958_k() - heldItem.func_77952_i();
        Block targetBlock = state.func_177230_c();
        Set<BlockPos> orePositions = OreEaterEnchantment.gatherBlocks(targetBlock, world, pos, 2 + Math.max(0, level - 1) * 2);
        for (BlockPos orePos : orePositions) {
            if (OreEaterEnchantment.destroyBlock(world, toolTypes, orePos, true, heldItem, player)) {
                ++damageAmount;
            }
            if (damageAmount < durability) continue;
            break;
        }
        heldItem.func_222118_a(damageAmount, (LivingEntity)player, player1 -> player1.func_213334_d(Hand.MAIN_HAND));
    }

    private static boolean destroyBlock(World world, Set<ToolType> toolTypes, BlockPos pos, boolean spawnDrops, ItemStack stack, PlayerEntity player) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.isAir((IBlockReader)world, pos)) {
            return false;
        }
        if (ExcavatorEnchantment.isToolEffective(toolTypes, blockState, player, world, pos)) {
            IFluidState fluidState = world.func_204610_c(pos);
            if (spawnDrops && !player.func_184812_l_()) {
                TileEntity tileEntity = blockState.hasTileEntity() ? world.func_175625_s(pos) : null;
                blockState.func_177230_c().func_180657_a(world, player, pos, blockState, tileEntity, stack);
            }
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            int silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack);
            int exp = blockState.getExpDrop((IWorldReader)world, pos, fortuneLevel, silkLevel);
            if (world.func_180501_a(pos, fluidState.func_206883_i(), 3) && !player.func_184812_l_()) {
                blockState.func_177230_c().func_180637_b(world, pos, exp);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerMineSpeed(PlayerEvent.BreakSpeed event) {
        float effectiveSpeed = OreEaterEnchantment.getEffectiveDigSpeed(event.getPlayer(), event.getPos());
        if (effectiveSpeed > 0.0f) {
            event.setNewSpeed(effectiveSpeed);
        }
    }

    private static float getEffectiveDigSpeed(PlayerEntity player, BlockPos pos) {
        BlockState state;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return 0.0f;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.ORE_EATER.get())) {
            return 0.0f;
        }
        if (!(heldItem.func_77973_b() instanceof PickaxeItem)) {
            return 0.0f;
        }
        int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)heldItem).get(ModEnchantments.ORE_EATER.get());
        World world = player.func_130014_f_();
        Set toolTypes = heldItem.func_77973_b().getToolTypes(heldItem);
        if (!ExcavatorEnchantment.isToolEffective(toolTypes, state = world.func_180495_p(pos), player, world, pos)) {
            return 0.0f;
        }
        if (!state.func_177230_c().func_203417_a(Tags.Blocks.ORES)) {
            return 0.0f;
        }
        float totalDigSpeed = 0.0f;
        int totalBlocks = 0;
        int durability = heldItem.func_77958_k() - heldItem.func_77952_i();
        Block targetBlock = state.func_177230_c();
        Set<BlockPos> orePositions = OreEaterEnchantment.gatherBlocks(targetBlock, world, pos, 2 + Math.max(0, level - 1) * 2);
        for (BlockPos orePos : orePositions) {
            state = world.func_180495_p(orePos);
            if (ExcavatorEnchantment.isToolEffective(toolTypes, state, player, world, orePos)) {
                totalDigSpeed += ExcavatorEnchantment.getDigSpeed(player, state, orePos);
                ++totalBlocks;
            }
            if (totalBlocks < durability) continue;
            break;
        }
        if (totalBlocks <= 0) {
            return 0.0f;
        }
        EffectInstance instance = player.func_70660_b(Effects.field_76422_e);
        if (instance != null) {
            totalBlocks = (int)((double)totalBlocks * ((double)instance.func_76458_c() * 0.5));
        }
        return totalDigSpeed / (float)totalBlocks / (float)totalBlocks;
    }

    public static Set<BlockPos> gatherBlocks(@Nullable Block targetBlock, World world, BlockPos pos, int depth) {
        LinkedList<BlockEntry> queue = new LinkedList<BlockEntry>();
        LinkedHashSet<BlockPos> explored = new LinkedHashSet<BlockPos>();
        queue.add(new BlockEntry(pos, depth));
        explored.add(pos);
        while (!queue.isEmpty()) {
            BlockEntry entry = (BlockEntry)queue.remove();
            if (entry.depth - 1 > 0) {
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177978_c(), queue, explored, entry.depth - 1);
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177974_f(), queue, explored, entry.depth - 1);
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177968_d(), queue, explored, entry.depth - 1);
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177976_e(), queue, explored, entry.depth - 1);
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177984_a(), queue, explored, entry.depth - 1);
                OreEaterEnchantment.addMatchingBlockToQueue(targetBlock, world, entry.pos.func_177977_b(), queue, explored, entry.depth - 1);
            }
            explored.add(entry.pos);
        }
        return explored;
    }

    private static void addMatchingBlockToQueue(@Nullable Block targetBlock, World world, BlockPos pos, Queue<BlockEntry> queue, Set<BlockPos> explored, int depth) {
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos)) {
            return;
        }
        if (!(targetBlock != null && state.func_177230_c() != targetBlock || explored.contains(pos))) {
            queue.offer(new BlockEntry(pos, depth));
        }
    }

    private static class BlockEntry {
        private BlockPos pos;
        private int depth;

        private BlockEntry(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockEntry blockEntry = (BlockEntry)o;
            return Objects.equals(this.pos, blockEntry.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

