/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.enchantment;

import com.mrcrayfish.enchantable.Enchantable;
import com.mrcrayfish.enchantable.core.ModEnchantments;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantable")
public class SeederEnchantment
extends Enchantment {
    public SeederEnchantment() {
        super(Enchantment.Rarity.RARE, Enchantable.HOE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof HoeItem;
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    @SubscribeEvent
    public static void onPlayerHarvestBlock(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() instanceof CropsBlock) {
            ItemStack heldItem = event.getPlayer().func_184614_ca();
            if (heldItem.func_190926_b()) {
                return;
            }
            if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.SEEDER.get())) {
                return;
            }
            World world = event.getPlayer().func_130014_f_();
            if (EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.CULTIVATOR.get())) {
                BlockPos pos = event.getPos().func_177982_a(-1, 0, -1);
                for (int i = 0; i < 9; ++i) {
                    BlockPos cropPos = pos.func_177982_a(i / 3, 0, i % 3);
                    BlockState state = world.func_180495_p(cropPos);
                    SeederEnchantment.replantCrop(state, world, cropPos, event.getPlayer(), event.getPos());
                }
            } else {
                SeederEnchantment.replantCrop(event.getState(), world, event.getPos(), event.getPlayer(), event.getPos());
            }
        }
    }

    private static void replantCrop(BlockState state, World world, BlockPos pos, PlayerEntity player, BlockPos originalPos) {
        if (state.func_177230_c() instanceof CropsBlock) {
            BlockItem blockItem;
            CropsBlock crop = (CropsBlock)state.func_177230_c();
            if (((Integer)state.func_177229_b((IProperty)crop.func_185524_e())).intValue() != crop.func_185526_g()) {
                return;
            }
            ItemStack stack = crop.func_185473_a((IBlockReader)world, pos, state);
            if (stack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof CropsBlock) {
                ItemStack seeds = ItemStack.field_190927_a;
                List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null);
                for (ItemStack drop2 : drops) {
                    if (drop2.func_77973_b() != stack.func_77973_b()) continue;
                    seeds = drop2.func_77979_a(1);
                    break;
                }
                if (seeds.func_190926_b()) {
                    seeds = SeederEnchantment.findSeeds(player, stack.func_77973_b());
                }
                drops.forEach(drop -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop));
                state.func_215706_a(world, pos, ItemStack.field_190927_a);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                if (!pos.equals((Object)originalPos)) {
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                }
                BlockState seedState = blockItem.func_179223_d().func_176223_P();
                if (!seeds.func_190926_b() & blockItem.func_179223_d().func_196260_a(seedState, (IWorldReader)world, pos)) {
                    MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
                    server.func_212871_a_((Runnable)new TickDelayedTask(0, () -> world.func_180501_a(pos, seedState, 3)));
                    seeds.func_190918_g(1);
                }
            }
        }
    }

    private static ItemStack findSeeds(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

