/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.enchantment;

import com.mrcrayfish.enchantable.Enchantable;
import com.mrcrayfish.enchantable.core.ModEnchantments;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantable")
public class CultivatorEnchantment
extends Enchantment {
    public CultivatorEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, Enchantable.TILLABLE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof HoeItem || stack.func_77973_b() instanceof ShovelItem;
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getItemStack().func_77973_b() instanceof ShovelItem)) {
            return;
        }
        int affectedBlocks = CultivatorEnchantment.till(event.getWorld(), event.getPos(), event.getFace(), event.getItemStack(), event.getPlayer(), ShovelItem.field_195955_e);
        if (affectedBlocks > 0) {
            event.getItemStack().func_222118_a(affectedBlocks, (LivingEntity)event.getPlayer(), player -> player.func_213334_d(event.getHand()));
            event.getPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseHoe(UseHoeEvent event) {
        ItemUseContext context = event.getContext();
        int affectedBlocks = CultivatorEnchantment.till(context.func_195991_k(), context.func_195995_a(), context.func_196000_l(), context.func_195996_i(), context.func_195999_j(), HoeItem.field_195973_b);
        if (affectedBlocks > 0 && context.func_195999_j() != null) {
            context.func_195996_i().func_222118_a(affectedBlocks - 1, (LivingEntity)context.func_195999_j(), player -> player.func_213334_d(context.func_221531_n()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerHarvestBlock(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() instanceof CropsBlock) {
            ItemStack heldItem = event.getPlayer().func_184614_ca();
            if (heldItem.func_190926_b()) {
                return;
            }
            if (EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.SEEDER.get())) {
                return;
            }
            if (!EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(ModEnchantments.CULTIVATOR.get())) {
                return;
            }
            World world = event.getPlayer().func_130014_f_();
            BlockPos pos = event.getPos().func_177982_a(-1, 0, -1);
            for (int i = 0; i < 9; ++i) {
                CropsBlock crop;
                BlockPos cropPos = pos.func_177982_a(i / 3, 0, i % 3);
                BlockState state = world.func_180495_p(cropPos);
                if (!(state.func_177230_c() instanceof CropsBlock) || ((Integer)state.func_177229_b((Property)(crop = (CropsBlock)state.func_177230_c()).func_185524_e())).intValue() != crop.func_185526_g()) continue;
                Block.func_220075_c((BlockState)state, (World)world, (BlockPos)cropPos);
                world.func_175656_a(cropPos, Blocks.field_150350_a.func_176223_P());
                if (cropPos.equals((Object)event.getPos())) continue;
                world.func_217379_c(2001, cropPos, Block.func_196246_j((BlockState)state));
            }
        }
    }

    private static int till(World world, BlockPos pos, Direction face, ItemStack stack, PlayerEntity player, Map<Block, BlockState> replacementMap) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.CULTIVATOR.get())) {
            return 0;
        }
        pos = pos.func_177982_a(-1, 0, -1);
        if (face != Direction.DOWN) {
            int maxBlocks = stack.func_77958_k() - stack.func_77952_i();
            int affectedBlocks = 0;
            for (int i = 0; i < 9 && i < maxBlocks; ++i) {
                BlockState groundState;
                BlockPos groundPos = pos.func_177982_a(i / 3, 0, i % 3);
                boolean air = world.func_175623_d(groundPos.func_177984_a());
                boolean replaceable = world.func_180495_p(groundPos.func_177984_a()).func_185904_a().func_76222_j();
                if (!air && !replaceable || (groundState = replacementMap.get(world.func_180495_p(groundPos).func_177230_c())) == null) continue;
                world.func_180501_a(groundPos, groundState, 11);
                ++affectedBlocks;
                if (air) continue;
                world.func_175656_a(groundPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            }
            if (affectedBlocks > 0) {
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return affectedBlocks;
            }
        }
        return 0;
    }
}

