/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.enchantable.enchantment;

import com.mrcrayfish.enchantable.core.ModEnchantments;
import com.mrcrayfish.enchantable.core.ModSounds;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantable")
public class StompingEnchantment
extends Enchantment {
    public StompingEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentType.ARMOR_FEET, new EquipmentSlotType[]{EquipmentSlotType.FEET});
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 4;
    }

    public int func_77321_a(int level) {
        return level * 10;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 15;
    }

    protected boolean func_77326_a(Enchantment enchantment) {
        if (enchantment instanceof ProtectionEnchantment) {
            ProtectionEnchantment protection = (ProtectionEnchantment)enchantment;
            return protection.field_77356_a != ProtectionEnchantment.Type.FALL;
        }
        return true;
    }

    @SubscribeEvent
    public static void onPlayerFallDamage(LivingDamageEvent event) {
        Map enchantments;
        PlayerEntity player;
        ItemStack stack;
        LivingEntity entity;
        if (event.getSource() == DamageSource.field_76379_h && (entity = event.getEntityLiving()) instanceof PlayerEntity && !(stack = (player = (PlayerEntity)entity).func_184582_a(EquipmentSlotType.FEET)).func_190926_b() && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(ModEnchantments.STOMPING.get())) {
            int level = (Integer)enchantments.get(ModEnchantments.STOMPING.get());
            float strengthFactor = 0.8f * ((float)level / 4.0f);
            List entities = player.field_70170_p.func_175647_a(LivingEntity.class, player.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0), LivingEntity::func_70089_S);
            entities.remove(player);
            if (entities.size() > 0) {
                float fallDamage = event.getAmount();
                event.setAmount(Math.max(0.0f, fallDamage - fallDamage * strengthFactor));
                for (LivingEntity livingEntity : entities) {
                    MinecraftServer server;
                    if (livingEntity instanceof PlayerEntity && !(server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_71219_W()) continue;
                    if (livingEntity.field_70170_p instanceof ServerWorld) {
                        BlockState state = livingEntity.field_70170_p.func_180495_p(livingEntity.func_233580_cy_().func_177977_b());
                        ServerWorld serverWorld = (ServerWorld)livingEntity.field_70170_p;
                        serverWorld.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), 50, 0.0, 0.0, 0.0, (double)0.15f);
                        serverWorld.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), ModSounds.ENTITY_PLAYER_STOMP, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    double stompStrength = 0.3 * ((double)level / 4.0);
                    Vector3d direction = new Vector3d(livingEntity.func_226277_ct_() - player.func_226277_ct_(), 0.0, livingEntity.func_226281_cx_() - player.func_226281_cx_()).func_72432_b();
                    livingEntity.func_213293_j(direction.field_72450_a * stompStrength, stompStrength, direction.field_72449_c * stompStrength);
                    livingEntity.func_70024_g(direction.field_72450_a * stompStrength, stompStrength, direction.field_72449_c * stompStrength);
                    livingEntity.field_70133_I = true;
                    float distance = livingEntity.func_70032_d((Entity)player);
                    float distanceFactor = Math.max(0.5f, 1.0f - distance / 5.0f);
                    livingEntity.func_70097_a(DamageSource.field_76377_j, fallDamage * strengthFactor * distanceFactor * 2.0f);
                    livingEntity.func_70604_c((LivingEntity)player);
                }
                stack.func_222118_a(entities.size(), (LivingEntity)player, entity1 -> entity1.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)EquipmentSlotType.FEET.func_188454_b())));
            }
        }
    }
}

