/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.EnhancedFarming;

import com.Mrbysco.EnhancedFarming.config.FarmingConfigGen;
import com.Mrbysco.EnhancedFarming.handler.FarmingHandlers;
import com.Mrbysco.EnhancedFarming.init.FarmingBlocks;
import com.Mrbysco.EnhancedFarming.init.FarmingItems;
import com.Mrbysco.EnhancedFarming.init.FarmingRecipes;
import com.Mrbysco.EnhancedFarming.init.FarmingTab;
import com.Mrbysco.EnhancedFarming.proxy.CommonProxy;
import com.Mrbysco.EnhancedFarming.tileentity.TileEntityScarecrow;
import com.Mrbysco.EnhancedFarming.world.NetherWorldGen;
import com.Mrbysco.EnhancedFarming.world.TreeWorldGen;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enhancedfarming", name="Enhanced Farming", version="1.1.3", acceptedMinecraftVersions="[1.12]")
public class EnhancedFarming {
    @Mod.Instance(value="enhancedfarming")
    public static EnhancedFarming instance;
    @SidedProxy(clientSide="com.Mrbysco.EnhancedFarming.proxy.ClientProxy", serverSide="com.Mrbysco.EnhancedFarming.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static FarmingTab tabFarming;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        logger.debug("Registering Config");
        MinecraftForge.EVENT_BUS.register((Object)new FarmingConfigGen());
        logger.debug("Registering Scarecrow TileEntity");
        GameRegistry.registerTileEntity(TileEntityScarecrow.class, (String)"enhancedfarming_scarecrow");
        if (!FarmingConfigGen.general.othersettings.enableRake) {
            logger.debug("Initializing Grass Seeds");
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Item)FarmingItems.mint_seeds), (int)5);
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Item)FarmingItems.nether_flower_seeds), (int)2);
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Block)FarmingBlocks.apple_sapling), (int)5);
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Block)FarmingBlocks.lemon_sapling), (int)5);
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Block)FarmingBlocks.orange_sapling), (int)5);
        }
        proxy.Preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.debug("Registering handlers");
        MinecraftForge.EVENT_BUS.register((Object)new FarmingHandlers());
        if (FarmingConfigGen.general.othersettings.treeGen) {
            logger.debug("Initializing Tree Generator");
            GameRegistry.registerWorldGenerator((IWorldGenerator)new TreeWorldGen(), (int)0);
        }
        if (FarmingConfigGen.general.othersettings.netherGen) {
            logger.debug("Initializing Nether Generator");
            GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherWorldGen(), (int)0);
        }
        logger.debug("Initializing Furnace Recipe");
        FarmingRecipes.init();
        FarmingRecipes.initOredict();
        proxy.Init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        logger = LogManager.getLogger((String)"enhancedfarming");
        tabFarming = new FarmingTab();
    }
}

