/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.EnhancedFarming.block;

import com.Mrbysco.EnhancedFarming.EnhancedFarming;
import com.Mrbysco.EnhancedFarming.block.EnumSaplingType;
import com.Mrbysco.EnhancedFarming.config.FarmingConfigGen;
import com.Mrbysco.EnhancedFarming.util.TreeHelper;
import com.Mrbysco.EnhancedFarming.world.WorldGenFruitTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockGrowableSapling
extends BlockBush
implements IGrowable,
IPlantable {
    private EnumSaplingType TYPE;
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)4);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockGrowableSapling(String registryName, EnumSaplingType type) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("enhancedfarming:" + registryName.replaceAll("_", ""));
        this.setRegistryName(registryName);
        this.func_149647_a(EnhancedFarming.tabFarming);
        this.TYPE = type;
    }

    public int getMatureStage() {
        return 3;
    }

    protected int getStage(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getStageProperty());
    }

    protected PropertyInteger getStageProperty() {
        return STAGE;
    }

    public boolean isMature(IBlockState state) {
        return this.func_176201_c(state) >= this.getMatureStage();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(6) == 0 && !this.isMature(state)) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = FarmingConfigGen.general.othersettings.instantGrow ? this.getStage(state) + (j - this.getStage(state)) : this.getStage(state) + this.getBonemealAgeIncrease(worldIn);
        if (i >= (j = this.getMatureStage())) {
            this.growTree(rand, worldIn, pos);
        } else {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 2);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (FarmingConfigGen.general.othersettings.bonemealGrow) {
            return (double)worldIn.field_73012_v.nextFloat() < 0.45;
        }
        return false;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5) / 4;
    }

    private void growTree(Random rand, World worldIn, BlockPos pos) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        worldIn.func_175698_g(pos);
        switch (this.TYPE) {
            case APPLE: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case BANANA: {
                new WorldGenFruitTree(this.TYPE, 3 + rand.nextInt(7)).func_180709_b(worldIn, rand, pos);
                break;
            }
            case CHERRY: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case LEMON: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case ORANGE: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case PEAR: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case AVOCADO: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
                break;
            }
            case MANGO: {
                new WorldGenFruitTree(this.TYPE, 5 + rand.nextInt(3)).func_180709_b(worldIn, rand, pos);
                break;
            }
            case OLIVE: {
                new WorldGenFruitTree(this.TYPE, 5 + rand.nextInt(3)).func_180709_b(worldIn, rand, pos);
                break;
            }
            default: {
                new WorldGenFruitTree(this.TYPE, 5).func_180709_b(worldIn, rand, pos);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickStack = new ItemStack((Block)TreeHelper.getSaplingFromEnum(this.TYPE));
        return pickStack;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }
}

