/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.EnhancedFarming.world;

import com.Mrbysco.EnhancedFarming.block.BlockGrowableSapling;
import com.Mrbysco.EnhancedFarming.block.EnumSaplingType;
import com.Mrbysco.EnhancedFarming.util.TreeHelper;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenFruitTree
extends WorldGenAbstractTree {
    private IBlockState woodType;
    private IBlockState leaveType;
    private BlockGrowableSapling saplingBlock;
    private final int minTreeHeight;

    public WorldGenFruitTree(EnumSaplingType type, int minTreeHeightIn) {
        super(true);
        this.minTreeHeight = minTreeHeightIn;
        this.woodType = type.getWoodType();
        this.leaveType = TreeHelper.getLeaveFromEnum(type).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.saplingBlock = TreeHelper.getSaplingFromEnum(type);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int treeSize = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + (treeSize += rand.nextInt(6)) + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + treeSize; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + treeSize - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)this.saplingBlock);
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - treeSize - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                for (int i2 = position.func_177956_o() - 3 + treeSize; i2 <= position.func_177956_o() + treeSize; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + treeSize);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = position.func_177958_n() - l2; i3 <= position.func_177958_n() + l2; ++i3) {
                        int j1 = i3 - position.func_177958_n();
                        for (int k1 = position.func_177952_p() - l2; k1 <= position.func_177952_p() + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, this.leaveType);
                        }
                    }
                }
                for (int j2 = 0; j2 < treeSize; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), this.woodType);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

