/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class FruitLeavesBlock
extends LeavesBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public final Supplier<Item> itemSupplier;

    public FruitLeavesBlock(AbstractBlock.Properties properties, Supplier<Item> itemSupplier) {
        super(properties.func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_(Blocks::func_235441_c_).func_235842_b_(Blocks::func_235436_b_).func_235847_c_(Blocks::func_235436_b_));
        this.itemSupplier = itemSupplier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_208494_a, (Comparable)Integer.valueOf(7))).func_206870_a((Property)field_208495_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(3)));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 30;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if ((Integer)state.func_177229_b((Property)field_208494_a) <= 6) {
            if (!this.isMaxAge(state)) {
                float f;
                if (!((Boolean)state.func_177229_b((Property)field_208495_b)).booleanValue() && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = 1.0f)) + 1) == 0 ? 1 : 0) != 0)) {
                    this.grow((World)world, pos, state, 1);
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
                }
            } else if (!world.field_72995_K && !((Boolean)FarmingConfig.COMMON.rightClickFruitHarvest.get()).booleanValue() && random.nextInt((Integer)FarmingConfig.COMMON.treeDropChance.get()) == 0) {
                ItemEntity fruitItem = new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o() - 0.2, (double)pos.func_177952_p(), new ItemStack((IItemProvider)this.itemSupplier.get()));
                world.func_217376_c((Entity)fruitItem);
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult traceResult) {
        if (((Boolean)FarmingConfig.COMMON.rightClickFruitHarvest.get()).booleanValue() && this.isMaxAge(state)) {
            ItemEntity fruitItem = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() - 0.2, (double)pos.func_177952_p(), new ItemStack((IItemProvider)this.itemSupplier.get()));
            world.func_217376_c((Entity)fruitItem);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, traceResult);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)0, (int)2);
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        this.grow((World)world, pos, state, this.getBonemealAgeIncrease((World)world));
    }

    public void grow(World worldIn, BlockPos pos, BlockState state, int increaseBy) {
        int j;
        int i = this.getAge(state) + increaseBy;
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    public boolean func_176473_a(IBlockReader blockReader, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public BlockState func_196258_a(BlockItemUseContext useContext) {
        return (BlockState)super.func_196258_a(useContext).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(3));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.func_206894_a(new Property[]{field_208494_a, field_208495_b, AGE});
    }
}

