/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.trees.Tree;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GrowableSaplingBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)4);
    private static final VoxelShape[] SHAPE_BY_STAGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)};
    private final Tree treeGrower;

    public GrowableSaplingBlock(Tree tree, AbstractBlock.Properties properties) {
        super(properties);
        this.treeGrower = tree;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getStageProperty() {
        return STAGE;
    }

    public int getMatureStage() {
        return 4;
    }

    protected int getStage(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getStageProperty());
    }

    public boolean isMature(BlockState state) {
        return this.getStage(state) >= this.getMatureStage();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            this.advanceTree(world, pos, state, random);
        }
    }

    public void advanceTree(ServerWorld world, BlockPos pos, BlockState state, Random random) {
        if (!this.isMature(state)) {
            if (((Boolean)FarmingConfig.COMMON.instantGrow.get()).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(this.getMatureStage())), 4);
            } else {
                world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)STAGE), 4);
            }
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)random, (BlockPos)pos)) {
                return;
            }
            this.treeGrower.func_230339_a_(world, world.func_72863_F().func_201711_g(), pos, state, random);
        }
    }

    public boolean func_176473_a(IBlockReader reader, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5) / 4;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        if (!this.isMature(state)) {
            int j = this.getMatureStage();
            int i = (Boolean)FarmingConfig.COMMON.instantGrow.get() != false ? this.getMatureStage() : this.getStage(state) + this.getBonemealAgeIncrease((World)world);
            if (i > j) {
                i = j;
            }
            if (((Boolean)FarmingConfig.COMMON.instantGrow.get()).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(this.getMatureStage())), 4);
            } else {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(i)), 4);
            }
        } else {
            this.advanceTree(world, pos, state, random);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_STAGE[(Integer)state.func_177229_b((Property)this.getStageProperty())];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.func_206894_a(new Property[]{STAGE});
    }
}

