/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block.crops;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import com.mrbysco.enhancedfarming.init.FarmingRegistry;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class NetherFlowerBlock
extends BushBlock
implements IGrowable {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};
    public static final IntegerProperty AGE = BlockStateProperties.field_208169_V;

    public NetherFlowerBlock(AbstractBlock.Properties properties) {
        super(properties.func_200944_c().func_200947_a(SoundType.field_222472_s));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public ItemStack func_185473_a(IBlockReader reader, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)FarmingRegistry.NETHER_FLOWER_SEEDS.get());
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader reader, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150425_aM);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.NETHER;
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return (Integer)p_149653_1_.func_177229_b((Property)AGE) < 5;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            state = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.func_180501_a(pos, state, 2);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE_BY_AGE[(Integer)p_220053_1_.func_177229_b((Property)AGE)];
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        if (((Boolean)FarmingConfig.COMMON.bonemealGrow.get()).booleanValue()) {
            return this.getAge(state) < this.getMaxAge();
        }
        return false;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.func_201674_k(), (int)2, (int)5) / 2;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        int j = this.getMaxAge();
        int i = (Boolean)FarmingConfig.COMMON.instantGrow.get() != false ? this.getMaxAge() : this.getAge(state) + this.getBonemealAgeIncrease((World)world);
        if (i > j) {
            i = j;
        }
        world.func_180501_a(pos, this.getStateForAge(i), 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{AGE});
    }
}

