/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.compat.jei.piston;

import com.mrbysco.enhancedfarming.compat.jei.JEICompat;
import com.mrbysco.enhancedfarming.recipes.PistonRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.util.ResourceLocation;

public class PistonCategory<T extends PistonRecipe>
implements IRecipeCategory<PistonRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public PistonCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JEICompat.RECIPE_PISTON_JEI, 0, 0, 84, 62);
        this.icon = guiHelper.createDrawable(JEICompat.RECIPE_PISTON_ICON_JEI, 0, 0, 16, 16);
        this.localizedName = Translator.translateToLocal((String)"enhancedfarming.gui.jei.category.piston");
    }

    public ResourceLocation getUid() {
        return JEICompat.PISTON;
    }

    public Class<? extends PistonRecipe> getRecipeClass() {
        return PistonRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PistonRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, PistonRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 22);
        guiItemStacks.init(1, false, 66, 22);
        guiItemStacks.set(ingredients);
    }
}

