/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.enhancedfarming.block.FruitLeavesBlock;
import com.mrbysco.enhancedfarming.block.GrowableSaplingBlock;
import com.mrbysco.enhancedfarming.block.crops.CropstickCropBlock;
import com.mrbysco.enhancedfarming.block.crops.NetherFlowerBlock;
import com.mrbysco.enhancedfarming.init.FarmingRegistry;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarmingDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new Loots(generator));
            generator.func_200390_a((IDataProvider)new Recipes(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new BlockStates(generator, helper));
            generator.func_200390_a((IDataProvider)new ItemModels(generator, helper));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerStatesAndModels() {
            this.buildCrops((CropsBlock)FarmingRegistry.MINT_CROP.get());
            this.buildNetherCrops((NetherFlowerBlock)FarmingRegistry.NETHER_FLOWER_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.TOMATO_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.CUCUMBER_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.AUBERGINE_CROP.get());
            this.buildStickCropCrops((CropstickCropBlock)FarmingRegistry.GRAPE_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.PINEAPPLE_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.CORN_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.ONION_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.GARLIC_CROP.get());
            this.buildCrops((CropsBlock)FarmingRegistry.LETTUCE_CROP.get());
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.APPLE_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.LEMON_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.ORANGE_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.CHERRY_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.PEAR_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.BANANA_SAPLING.get(), "jungle_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.AVOCADO_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.MANGO_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.OLIVE_SAPLING.get(), "acacia_sapling");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.APPLE_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.LEMON_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.ORANGE_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.CHERRY_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.PEAR_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.BANANA_LEAVES.get(), "jungle_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.AVOCADO_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.MANGO_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.OLIVE_LEAVES.get(), "acacia_leaves");
            this.model((Block)FarmingRegistry.CROP_STICK.get());
            this.horizontalBlock((Block)FarmingRegistry.SCARECROW.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/scarecrow")));
        }

        protected void model(Block block) {
            ModelFile.ExistingModelFile file = this.models().getExistingFile(block.getRegistryName());
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$model$0((ModelFile)file, arg_0));
        }

        protected void buildNetherCrops(NetherFlowerBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().func_110623_a() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().func_110623_a() + "_" + i));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildCrops(CropsBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.func_185526_g(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().func_110623_a() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().func_110623_a() + "_" + i));
                builder.partialState().with((Property)block.func_185524_e(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildStickCropCrops(CropstickCropBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.func_185526_g(); ++i) {
                ModelBuilder file = this.models().singleTexture(block.getRegistryName().func_110623_a() + "_" + i, this.modLoc("block/stick_crops"), "crop", new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().func_110623_a() + "_" + i));
                builder.partialState().with((Property)block.func_185524_e(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildSaplings(GrowableSaplingBlock block, String base) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMatureStage(); ++i) {
                ModelBuilder file;
                if (i == block.getMatureStage()) {
                    file = this.models().crop(block.getRegistryName().func_110623_a() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + block.getRegistryName().func_110623_a()));
                    builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = this.models().crop(block.getRegistryName().func_110623_a() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + base + "_" + i));
                builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildLeaves(FruitLeavesBlock block, String originalLeaves) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file;
                if (i != block.getMaxAge()) {
                    file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().func_110623_a() + "_blooming", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().func_110623_a() + "_blooming"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                    builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().func_110623_a() + "_fruity", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().func_110623_a() + "_fruity"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        private static /* synthetic */ ConfiguredModel[] lambda$model$0(ModelFile file, BlockState state) {
            return ConfiguredModel.builder().modelFile(file).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerModels() {
            FarmingRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
                if (!path.equals("scarecrow")) {
                    if (path.endsWith("_sapling")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("block/saplings/" + path));
                    } else if (path.endsWith("_leaves")) {
                        this.withExistingParent(path, this.modLoc("block/" + path + "_fruity"));
                    } else if (path.endsWith("_rake")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
                    } else {
                        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
                    }
                }
            });
        }

        public String func_200397_b() {
            return "Item Models";
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "enhancedfarming", "en_us");
        }

        protected void addTranslations() {
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        }

        protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path path) {
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new FarmingBlocks(), (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
            map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class FarmingBlocks
        extends BlockLootTables {
            private final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            private final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

            private FarmingBlocks() {
            }

            protected void addTables() {
                this.func_218492_c((Block)FarmingRegistry.APPLE_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.LEMON_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.ORANGE_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.CHERRY_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.PEAR_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.BANANA_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.AVOCADO_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.MANGO_SAPLING.get());
                this.func_218492_c((Block)FarmingRegistry.OLIVE_SAPLING.get());
                this.func_218522_a((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.LEMON_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.LEMON_LEAVES.get()), (Block)((Block)FarmingRegistry.LEMON_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.ORANGE_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.ORANGE_LEAVES.get()), (Block)((Block)FarmingRegistry.ORANGE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.CHERRY_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.CHERRY_LEAVES.get()), (Block)((Block)FarmingRegistry.CHERRY_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.PEAR_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.PEAR_LEAVES.get()), (Block)((Block)FarmingRegistry.PEAR_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.BANANA_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.BANANA_LEAVES.get()), (Block)((Block)FarmingRegistry.BANANA_SAPLING.get()), (float[])this.JUNGLE_LEAVES_SAPLING_CHANGES));
                this.func_218522_a((Block)FarmingRegistry.AVOCADO_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.AVOCADO_LEAVES.get()), (Block)((Block)FarmingRegistry.AVOCADO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.MANGO_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.MANGO_LEAVES.get()), (Block)((Block)FarmingRegistry.MANGO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.OLIVE_LEAVES.get(), block -> FarmingBlocks.func_218540_a((Block)((Block)FarmingRegistry.OLIVE_LEAVES.get()), (Block)((Block)FarmingRegistry.OLIVE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.func_218522_a((Block)FarmingRegistry.CROP_STICK.get(), block -> FarmingBlocks.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)FarmingBlocks.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)3)))))));
                this.func_218522_a((Block)FarmingRegistry.MINT_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.MINT_CROP.get()), (Item)((Item)FarmingRegistry.MINT.get()), (Item)((Item)FarmingRegistry.MINT_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.MINT_CROP.get())));
                BlockStateProperty.Builder netherBuilder = BlockStateProperty.func_215985_a((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)NetherFlowerBlock.AGE, 5));
                this.func_218522_a((Block)FarmingRegistry.NETHER_FLOWER_CROP.get(), arg_0 -> FarmingBlocks.lambda$addTables$12((ILootCondition.IBuilder)netherBuilder, arg_0));
                this.func_218522_a((Block)FarmingRegistry.TOMATO_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.TOMATO_CROP.get()), (Item)((Item)FarmingRegistry.TOMATO.get()), (Item)((Item)FarmingRegistry.TOMATO_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.TOMATO_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.CUCUMBER_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.CUCUMBER_CROP.get()), (Item)((Item)FarmingRegistry.CUCUMBER.get()), (Item)((Item)FarmingRegistry.CUCUMBER_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.CUCUMBER_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.AUBERGINE_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.AUBERGINE_CROP.get()), (Item)((Item)FarmingRegistry.AUBERGINE.get()), (Item)((Item)FarmingRegistry.AUBERGINE_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.AUBERGINE_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.GRAPE_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.GRAPE_CROP.get()), (Item)((Item)FarmingRegistry.GRAPES.get()), (Item)((Item)FarmingRegistry.GRAPE_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.GRAPE_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.PINEAPPLE_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.PINEAPPLE_CROP.get()), (Item)((Item)FarmingRegistry.PINEAPPLE.get()), (Item)((Item)FarmingRegistry.PINEAPPLE_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.PINEAPPLE_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.CORN_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.CORN_CROP.get()), (Item)((Item)FarmingRegistry.CORN.get()), (Item)((Item)FarmingRegistry.CORN_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.CORN_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.ONION_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.ONION_CROP.get()), (Item)((Item)FarmingRegistry.ONION.get()), (Item)((Item)FarmingRegistry.ONION_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.ONION_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.GARLIC_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.GARLIC_CROP.get()), (Item)((Item)FarmingRegistry.GARLIC.get()), (Item)((Item)FarmingRegistry.GARLIC_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.GARLIC_CROP.get())));
                this.func_218522_a((Block)FarmingRegistry.LETTUCE_CROP.get(), block -> FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.LETTUCE_CROP.get()), (Item)((Item)FarmingRegistry.LETTUCE.get()), (Item)((Item)FarmingRegistry.LETTUCE_SEEDS.get()), (ILootCondition.IBuilder)this.getBuilder((CropsBlock)FarmingRegistry.LETTUCE_CROP.get())));
                this.func_218492_c((Block)FarmingRegistry.SCARECROW.get());
            }

            public ILootCondition.IBuilder getBuilder(CropsBlock block) {
                return BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)block.func_185524_e(), block.func_185526_g()));
            }

            protected Iterable<Block> getKnownBlocks() {
                return FarmingRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }

            private static /* synthetic */ LootTable.Builder lambda$addTables$12(ILootCondition.IBuilder netherBuilder, Block block) {
                return FarmingBlocks.func_218541_a((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get()), (Item)Items.field_151072_bj, (Item)((Item)FarmingRegistry.NETHER_FLOWER_SEEDS.get()), (ILootCondition.IBuilder)netherBuilder);
            }
        }
    }
}

