/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.handler;

import com.mrbysco.enhancedfarming.recipes.FarmingRecipes;
import com.mrbysco.enhancedfarming.recipes.PistonRecipe;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InWorldCraftingHandler {
    @SubscribeEvent
    public void InWorldCrafting(PistonEvent.Post event) {
        if (!event.getWorld().func_201670_d() && event.getPistonMoveType() == PistonEvent.PistonMoveType.EXTEND) {
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockPos pos = event.getFaceOffsetPos();
            float range = 1.0f;
            List itemEntities = world.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)((float)pos.func_177956_o() - 1.0f), (double)((float)pos.func_177952_p() - 1.0f), (double)((float)pos.func_177958_n() + 1.0f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 1.0f)));
            if (!itemEntities.isEmpty()) {
                for (ItemEntity itemEntity : itemEntities) {
                    BlockPos itemPos = itemEntity.func_233580_cy_();
                    SingularInventory inventory = this.createInventory(itemEntity);
                    PistonRecipe recipe = world.func_199532_z().func_215371_a(FarmingRecipes.PISTON_CRAFTING_TYPE, (IInventory)inventory, (World)world).orElse(null);
                    if (recipe == null) continue;
                    ItemStack stack = itemEntity.func_92059_d();
                    int craftPer = 0;
                    int craftCount = 0;
                    if (!((Ingredient)recipe.func_192400_c().get(0)).func_203189_d()) {
                        ItemStack[] ingredients;
                        for (ItemStack ingredient : ingredients = ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()) {
                            if (ingredient.func_77973_b() != stack.func_77973_b()) continue;
                            craftPer = ingredient.func_190916_E();
                            craftCount = (int)Math.ceil((double)stack.func_190916_E() / (double)ingredient.func_190916_E());
                            break;
                        }
                    }
                    if (craftCount <= 0) continue;
                    int total = craftCount * craftPer;
                    ItemStack result = recipe.func_77571_b().func_77946_l();
                    int maxResultSize = result.func_77976_d();
                    if (total <= maxResultSize) {
                        stack.func_190918_g(total);
                        if (stack.func_190926_b()) {
                            itemEntity.func_70106_y();
                        } else {
                            itemEntity.func_92058_a(stack);
                        }
                        result.func_190920_e(total);
                        ItemEntity newItemEntity = new ItemEntity((World)world, (double)itemPos.func_177958_n(), (double)itemPos.func_177956_o(), (double)itemPos.func_177952_p(), result);
                        world.func_217376_c((Entity)newItemEntity);
                        continue;
                    }
                    int totalStacks = (int)Math.floor((double)total / (double)maxResultSize);
                    int currentTotal = total;
                    for (int i = 0; i < totalStacks; ++i) {
                        ItemStack newStack = recipe.func_77571_b().func_77946_l();
                        if (currentTotal > maxResultSize) {
                            newStack.func_190920_e(maxResultSize);
                            currentTotal -= maxResultSize;
                        } else {
                            newStack.func_190920_e(currentTotal);
                        }
                        ItemEntity newItemEntity = new ItemEntity((World)world, (double)itemPos.func_177958_n(), (double)itemPos.func_177956_o(), (double)itemPos.func_177952_p(), newStack);
                        world.func_217376_c((Entity)newItemEntity);
                    }
                }
            }
        }
    }

    public SingularInventory createInventory(ItemEntity itemEntity) {
        SingularInventory inventory = new SingularInventory();
        inventory.func_70299_a(0, itemEntity.func_92059_d().func_77946_l());
        return inventory;
    }

    public static class SingularInventory
    implements IInventory {
        private final NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            for (ItemStack itemstack : this.itemStacks) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return (ItemStack)this.itemStacks.get(0);
        }

        public ItemStack func_70298_a(int slot, int p_70298_2_) {
            return ItemStackHelper.func_188383_a(this.itemStacks, (int)0);
        }

        public ItemStack func_70304_b(int slot) {
            return ItemStackHelper.func_188383_a(this.itemStacks, (int)0);
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.itemStacks.set(0, (Object)stack);
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174888_l() {
            this.itemStacks.clear();
        }
    }
}

