/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.item;

import com.google.common.collect.Sets;
import com.mrbysco.enhancedfarming.init.FarmingLootTables;
import com.mrbysco.enhancedfarming.init.FarmingTags;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class RakeToolItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_150391_bh, Blocks.field_196661_l, Blocks.field_196660_k});
    private final int dropModifier;

    public RakeToolItem(IItemTier itemTier, int attackDamage, float attackSpeed, int dropModifier, Item.Properties properties) {
        super((float)attackDamage, attackSpeed, itemTier, EFFECTIVE_ON, properties.addToolType(ToolType.get((String)"rake"), itemTier.func_200925_d()));
        this.dropModifier = dropModifier;
    }

    public void dropSeedsWithChance(ItemStack itemstack, World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(30 / this.dropModifier) == 0) {
            LootTable table = worldIn.func_73046_m().func_200249_aQ().func_186521_a(FarmingLootTables.GAMEPLAY_RAKE_DROPS);
            LootContext.Builder context = new LootContext.Builder((ServerWorld)worldIn).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_216015_a(LootParameters.field_216289_i, (Object)itemstack).func_216023_a(worldIn.field_73012_v);
            table.func_216113_a(context.func_216022_a(LootParameterSets.field_216260_a)).forEach(stack -> worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p(), stack)));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a())) {
            if (world.func_180495_p(blockpos).func_235714_a_(FarmingTags.RAKE_BLOCKS)) {
                BlockState dirtState = Blocks.field_150346_d.func_176223_P();
                PlayerEntity playerentity = context.func_195999_j();
                world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(blockpos, dirtState, 11);
                    if (playerentity != null) {
                        context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                        this.dropSeedsWithChance(context.func_195996_i(), world, blockpos);
                    }
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }
}

