/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.enhancedfarming.recipes.FarmingRecipes;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PistonRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;

    public PistonRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack stack) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
    }

    public IRecipeType<?> func_222127_g() {
        return FarmingRecipes.PISTON_CRAFTING_TYPE;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inventory) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)FarmingRecipes.PISTON_CRAFTING_SERIALIZER.get();
    }

    public static class SerializerPistonRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PistonRecipe> {
        public PistonRecipe fromJson(ResourceLocation recipeId, JsonObject jsonObject) {
            ItemStack itemstack;
            String s = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)jsonObject, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            return new PistonRecipe(recipeId, s, ingredient, itemstack);
        }

        @Nullable
        public PistonRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return new PistonRecipe(recipeId, s, ingredient, itemstack);
        }

        public void toNetwork(PacketBuffer buffer, PistonRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

