/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;

public class FruitLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public final Supplier<Item> itemSupplier;

    public FruitLeavesBlock(BlockBehaviour.Properties properties, Supplier<Item> itemSupplier) {
        super(properties.m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_56740_).m_60955_().m_60922_(Blocks::m_50821_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_));
        this.itemSupplier = itemSupplier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 30;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        super.m_7458_(state, world, pos, random);
        if ((Integer)state.m_61143_((Property)f_54418_) <= 6) {
            if (!this.isMaxAge(state)) {
                float f;
                if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = 1.0f)) + 1) == 0 ? 1 : 0) != 0)) {
                    this.grow((Level)world, pos, state, 1);
                    ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
                }
            } else if (!world.f_46443_ && !((Boolean)FarmingConfig.COMMON.rightClickFruitHarvest.get()).booleanValue() && random.nextInt((Integer)FarmingConfig.COMMON.treeDropChance.get()) == 0) {
                ItemEntity fruitItem = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_() - 0.2, (double)pos.m_123343_(), new ItemStack((ItemLike)this.itemSupplier.get()));
                world.m_7967_((Entity)fruitItem);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult traceResult) {
        if (((Boolean)FarmingConfig.COMMON.rightClickFruitHarvest.get()).booleanValue() && this.isMaxAge(state)) {
            ItemEntity fruitItem = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() - 0.2, (double)pos.m_123343_(), new ItemStack((ItemLike)this.itemSupplier.get()));
            world.m_7967_((Entity)fruitItem);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, traceResult);
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_14072_((Random)worldIn.f_46441_, (int)0, (int)2);
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        this.grow((Level)world, pos, state, this.getBonemealAgeIncrease((Level)world));
    }

    public void grow(Level worldIn, BlockPos pos, BlockState state, int increaseBy) {
        int j;
        int i = this.getAge(state) + increaseBy;
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.m_7731_(pos, this.withAge(i), 2);
    }

    public boolean m_7370_(BlockGetter blockReader, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return (double)world.f_46441_.nextFloat() < 0.45;
    }

    public BlockState m_5573_(BlockPlaceContext useContext) {
        return (BlockState)super.m_5573_(useContext).m_61124_((Property)AGE, (Comparable)Integer.valueOf(3));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{f_54418_, f_54419_, AGE});
    }
}

