/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class GrowableSaplingBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)4);
    private static final VoxelShape[] SHAPE_BY_STAGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)};
    private final AbstractTreeGrower treeGrower;

    public GrowableSaplingBlock(AbstractTreeGrower tree, BlockBehaviour.Properties properties) {
        super(properties);
        this.treeGrower = tree;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getStageProperty() {
        return STAGE;
    }

    public int getMatureStage() {
        return 4;
    }

    protected int getStage(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getStageProperty());
    }

    public boolean isMature(BlockState state) {
        return this.getStage(state) >= this.getMatureStage();
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (world.m_46803_(pos.m_7494_()) >= 9 && random.nextInt(7) == 0) {
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            this.advanceTree(world, pos, state, random);
        }
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState state, Random random) {
        if (!this.isMature(state)) {
            if (((Boolean)FarmingConfig.COMMON.instantGrow.get()).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(this.getMatureStage())), 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)STAGE), 4);
            }
        } else {
            if (!ForgeEventFactory.saplingGrowTree((LevelAccessor)world, (Random)random, (BlockPos)pos)) {
                return;
            }
            this.treeGrower.m_6334_(world, world.m_7726_().m_8481_(), pos, state, random);
        }
    }

    public boolean m_7370_(BlockGetter reader, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return (double)world.f_46441_.nextFloat() < 0.45;
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_14072_((Random)worldIn.f_46441_, (int)2, (int)5) / 4;
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        if (!this.isMature(state)) {
            int j = this.getMatureStage();
            int i = (Boolean)FarmingConfig.COMMON.instantGrow.get() != false ? this.getMatureStage() : this.getStage(state) + this.getBonemealAgeIncrease((Level)world);
            if (i > j) {
                i = j;
            }
            if (((Boolean)FarmingConfig.COMMON.instantGrow.get()).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(this.getMatureStage())), 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(i)), 4);
            }
        } else {
            this.advanceTree(world, pos, state, random);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_STAGE[(Integer)state.m_61143_((Property)this.getStageProperty())];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{STAGE});
    }
}

