/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.block.crops;

import com.mrbysco.enhancedfarming.config.FarmingConfig;
import com.mrbysco.enhancedfarming.init.FarmingRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class NetherFlowerBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;

    public NetherFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_().m_60918_(SoundType.f_56758_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_7397_(BlockGetter reader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FarmingRegistry.NETHER_FLOWER_SEEDS.get());
    }

    protected boolean m_6266_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60713_(Blocks.f_50135_);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.NETHER;
    }

    public boolean m_6724_(BlockState p_149653_1_) {
        return (Integer)p_149653_1_.m_61143_((Property)AGE) < 5;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.m_7731_(pos, state, 2);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE_BY_AGE[(Integer)p_220053_1_.m_61143_((Property)AGE)];
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        if (((Boolean)FarmingConfig.COMMON.bonemealGrow.get()).booleanValue()) {
            return this.getAge(state) < this.getMaxAge();
        }
        return false;
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_14072_((Random)worldIn.m_5822_(), (int)2, (int)5) / 2;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        int j = this.getMaxAge();
        int i = (Boolean)FarmingConfig.COMMON.instantGrow.get() != false ? this.getMaxAge() : this.getAge(state) + this.getBonemealAgeIncrease((Level)world);
        if (i > j) {
            i = j;
        }
        world.m_7731_(pos, this.getStateForAge(i), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{AGE});
    }
}

