/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.enhancedfarming.block.FruitLeavesBlock;
import com.mrbysco.enhancedfarming.block.GrowableSaplingBlock;
import com.mrbysco.enhancedfarming.block.crops.CropstickCropBlock;
import com.mrbysco.enhancedfarming.block.crops.NetherFlowerBlock;
import com.mrbysco.enhancedfarming.init.FarmingRegistry;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarmingDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new FarmingLoot(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new FarmingBlockStates(generator, helper));
            generator.m_123914_((DataProvider)new FarmingItemModels(generator, helper));
        }
    }

    private static class FarmingLoot
    extends LootTableProvider {
        public FarmingLoot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(FarmingBlocks::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class FarmingBlocks
        extends BlockLoot {
            private final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            private final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

            private FarmingBlocks() {
            }

            protected void addTables() {
                this.m_124288_((Block)FarmingRegistry.APPLE_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.LEMON_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.ORANGE_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.CHERRY_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.PEAR_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.BANANA_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.AVOCADO_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.MANGO_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.OLIVE_SAPLING.get());
                this.m_124175_((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.LEMON_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.LEMON_LEAVES.get()), (Block)((Block)FarmingRegistry.LEMON_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.ORANGE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.ORANGE_LEAVES.get()), (Block)((Block)FarmingRegistry.ORANGE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.CHERRY_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.CHERRY_LEAVES.get()), (Block)((Block)FarmingRegistry.CHERRY_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.PEAR_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.PEAR_LEAVES.get()), (Block)((Block)FarmingRegistry.PEAR_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.BANANA_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.BANANA_LEAVES.get()), (Block)((Block)FarmingRegistry.BANANA_SAPLING.get()), (float[])this.JUNGLE_LEAVES_SAPLING_CHANGES));
                this.m_124175_((Block)FarmingRegistry.AVOCADO_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.AVOCADO_LEAVES.get()), (Block)((Block)FarmingRegistry.AVOCADO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.MANGO_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.MANGO_LEAVES.get()), (Block)((Block)FarmingRegistry.MANGO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.OLIVE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.OLIVE_LEAVES.get()), (Block)((Block)FarmingRegistry.OLIVE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.CROP_STICK.get(), block -> FarmingBlocks.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)FarmingBlocks.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)))))));
                this.m_124175_((Block)FarmingRegistry.MINT_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.MINT_CROP.get()), (Item)((Item)FarmingRegistry.MINT.get()), (Item)((Item)FarmingRegistry.MINT_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.MINT_CROP.get())));
                LootItemBlockStatePropertyCondition.Builder netherBuilder = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)NetherFlowerBlock.AGE, 5));
                this.m_124175_((Block)FarmingRegistry.NETHER_FLOWER_CROP.get(), arg_0 -> FarmingBlocks.lambda$addTables$12((LootItemCondition.Builder)netherBuilder, arg_0));
                this.m_124175_((Block)FarmingRegistry.TOMATO_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.TOMATO_CROP.get()), (Item)((Item)FarmingRegistry.TOMATO.get()), (Item)((Item)FarmingRegistry.TOMATO_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.TOMATO_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.CUCUMBER_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.CUCUMBER_CROP.get()), (Item)((Item)FarmingRegistry.CUCUMBER.get()), (Item)((Item)FarmingRegistry.CUCUMBER_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.CUCUMBER_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.AUBERGINE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.AUBERGINE_CROP.get()), (Item)((Item)FarmingRegistry.AUBERGINE.get()), (Item)((Item)FarmingRegistry.AUBERGINE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.AUBERGINE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.GRAPE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.GRAPE_CROP.get()), (Item)((Item)FarmingRegistry.GRAPES.get()), (Item)((Item)FarmingRegistry.GRAPE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.GRAPE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.PINEAPPLE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.PINEAPPLE_CROP.get()), (Item)((Item)FarmingRegistry.PINEAPPLE.get()), (Item)((Item)FarmingRegistry.PINEAPPLE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.PINEAPPLE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.CORN_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.CORN_CROP.get()), (Item)((Item)FarmingRegistry.CORN.get()), (Item)((Item)FarmingRegistry.CORN_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.CORN_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.ONION_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.ONION_CROP.get()), (Item)((Item)FarmingRegistry.ONION.get()), (Item)((Item)FarmingRegistry.ONION_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.ONION_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.GARLIC_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.GARLIC_CROP.get()), (Item)((Item)FarmingRegistry.GARLIC.get()), (Item)((Item)FarmingRegistry.GARLIC_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.GARLIC_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.LETTUCE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.LETTUCE_CROP.get()), (Item)((Item)FarmingRegistry.LETTUCE.get()), (Item)((Item)FarmingRegistry.LETTUCE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.LETTUCE_CROP.get())));
                this.m_124288_((Block)FarmingRegistry.SCARECROW.get());
            }

            public LootItemCondition.Builder getBuilder(CropBlock block) {
                return LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.m_7959_(), block.m_7419_()));
            }

            protected Iterable<Block> getKnownBlocks() {
                return FarmingRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }

            private static /* synthetic */ LootTable.Builder lambda$addTables$12(LootItemCondition.Builder netherBuilder, Block block) {
                return FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get()), (Item)Items.f_42585_, (Item)((Item)FarmingRegistry.NETHER_FLOWER_SEEDS.get()), (LootItemCondition.Builder)netherBuilder);
            }
        }
    }

    private static class FarmingBlockStates
    extends BlockStateProvider {
        public FarmingBlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerStatesAndModels() {
            this.buildCrops((CropBlock)FarmingRegistry.MINT_CROP.get());
            this.buildNetherCrops((NetherFlowerBlock)FarmingRegistry.NETHER_FLOWER_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.TOMATO_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.CUCUMBER_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.AUBERGINE_CROP.get());
            this.buildStickCropCrops((CropstickCropBlock)FarmingRegistry.GRAPE_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.PINEAPPLE_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.CORN_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.ONION_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.GARLIC_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.LETTUCE_CROP.get());
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.APPLE_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.LEMON_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.ORANGE_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.CHERRY_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.PEAR_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.BANANA_SAPLING.get(), "jungle_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.AVOCADO_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.MANGO_SAPLING.get(), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)FarmingRegistry.OLIVE_SAPLING.get(), "acacia_sapling");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.APPLE_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.LEMON_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.ORANGE_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.CHERRY_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.PEAR_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.BANANA_LEAVES.get(), "jungle_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.AVOCADO_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.MANGO_LEAVES.get(), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)FarmingRegistry.OLIVE_LEAVES.get(), "acacia_leaves");
            this.model((Block)FarmingRegistry.CROP_STICK.get());
            this.horizontalBlock((Block)FarmingRegistry.SCARECROW.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/scarecrow")));
        }

        protected void model(Block block) {
            ModelFile.ExistingModelFile file = this.models().getExistingFile(block.getRegistryName());
            this.getVariantBuilder(block).forAllStates(arg_0 -> FarmingBlockStates.lambda$model$0((ModelFile)file, arg_0));
        }

        protected void buildNetherCrops(NetherFlowerBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildCrops(CropBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.m_7419_(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.m_7959_(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildStickCropCrops(CropstickCropBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.m_7419_(); ++i) {
                ModelBuilder file = this.models().singleTexture(block.getRegistryName().m_135815_() + "_" + i, this.modLoc("block/stick_crops"), "crop", new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.m_7959_(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildSaplings(GrowableSaplingBlock block, String base) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMatureStage(); ++i) {
                ModelBuilder file;
                if (i == block.getMatureStage()) {
                    file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + block.getRegistryName().m_135815_()));
                    builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + base + "_" + i));
                builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildLeaves(FruitLeavesBlock block, String originalLeaves) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file;
                if (i != block.getMaxAge()) {
                    file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().m_135815_() + "_blooming", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().m_135815_() + "_blooming"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                    builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().m_135815_() + "_fruity", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().m_135815_() + "_fruity"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        private static /* synthetic */ ConfiguredModel[] lambda$model$0(ModelFile file, BlockState state) {
            return ConfiguredModel.builder().modelFile(file).build();
        }
    }

    private static class FarmingItemModels
    extends ItemModelProvider {
        public FarmingItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerModels() {
            FarmingRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = Objects.requireNonNull(item.getRegistryName()).m_135815_();
                if (!path.equals("scarecrow")) {
                    if (path.endsWith("_sapling")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("block/saplings/" + path));
                    } else if (path.endsWith("_leaves")) {
                        this.withExistingParent(path, this.modLoc("block/" + path + "_fruity"));
                    } else if (path.endsWith("_rake")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
                    } else {
                        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
                    }
                }
            });
        }

        public String m_6055_() {
            return "Item Models";
        }
    }

    private static class FarmingLanguage
    extends LanguageProvider {
        public FarmingLanguage(DataGenerator gen) {
            super(gen, "enhancedfarming", "en_us");
        }

        protected void addTranslations() {
        }
    }

    private static class FarmingRecipes
    extends RecipeProvider {
        public FarmingRecipes(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        }

        protected void m_126013_(HashCache cache, JsonObject advancementJson, Path path) {
        }
    }
}

