/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.handler;

import com.mrbysco.enhancedfarming.recipes.FarmingRecipes;
import com.mrbysco.enhancedfarming.recipes.PistonRecipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InWorldCraftingHandler {
    @SubscribeEvent
    public void InWorldCrafting(PistonEvent.Post event) {
        if (!event.getWorld().m_5776_() && event.getPistonMoveType() == PistonEvent.PistonMoveType.EXTEND) {
            ServerLevel world = (ServerLevel)event.getWorld();
            BlockPos pos = event.getFaceOffsetPos();
            float range = 1.0f;
            List itemEntities = world.m_45976_(ItemEntity.class, new AABB((double)(pos.m_123341_() - 1), (double)((float)pos.m_123342_() - 1.0f), (double)((float)pos.m_123343_() - 1.0f), (double)((float)pos.m_123341_() + 1.0f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 1.0f)));
            if (!itemEntities.isEmpty()) {
                for (ItemEntity itemEntity : itemEntities) {
                    BlockPos itemPos = itemEntity.m_142538_();
                    SingularInventory inventory = this.createInventory(itemEntity);
                    PistonRecipe recipe = world.m_7465_().m_44015_(FarmingRecipes.PISTON_CRAFTING_TYPE, (Container)inventory, (Level)world).orElse(null);
                    if (recipe == null) continue;
                    ItemStack stack = itemEntity.m_32055_();
                    int craftPer = 0;
                    int craftCount = 0;
                    if (!((Ingredient)recipe.m_7527_().get(0)).m_43947_()) {
                        ItemStack[] ingredients;
                        for (ItemStack ingredient : ingredients = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
                            if (ingredient.m_41720_() != stack.m_41720_()) continue;
                            craftPer = ingredient.m_41613_();
                            craftCount = (int)Math.ceil((double)stack.m_41613_() / (double)ingredient.m_41613_());
                            break;
                        }
                    }
                    if (craftCount <= 0) continue;
                    int total = craftCount * craftPer;
                    ItemStack result = recipe.m_8043_().m_41777_();
                    int maxResultSize = result.m_41741_();
                    if (total <= maxResultSize) {
                        stack.m_41774_(total);
                        if (stack.m_41619_()) {
                            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                        } else {
                            itemEntity.m_32045_(stack);
                        }
                        result.m_41764_(total);
                        ItemEntity newItemEntity = new ItemEntity((Level)world, (double)itemPos.m_123341_(), (double)itemPos.m_123342_(), (double)itemPos.m_123343_(), result);
                        world.m_7967_((Entity)newItemEntity);
                        continue;
                    }
                    int totalStacks = (int)Math.floor((double)total / (double)maxResultSize);
                    int currentTotal = total;
                    for (int i = 0; i < totalStacks; ++i) {
                        ItemStack newStack = recipe.m_8043_().m_41777_();
                        if (currentTotal > maxResultSize) {
                            newStack.m_41764_(maxResultSize);
                            currentTotal -= maxResultSize;
                        } else {
                            newStack.m_41764_(currentTotal);
                        }
                        ItemEntity newItemEntity = new ItemEntity((Level)world, (double)itemPos.m_123341_(), (double)itemPos.m_123342_(), (double)itemPos.m_123343_(), newStack);
                        world.m_7967_((Entity)newItemEntity);
                    }
                }
            }
        }
    }

    public SingularInventory createInventory(ItemEntity itemEntity) {
        SingularInventory inventory = new SingularInventory();
        inventory.m_6836_(0, itemEntity.m_32055_().m_41777_());
        return inventory;
    }

    public static class SingularInventory
    implements Container {
        private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            for (ItemStack itemstack : this.itemStacks) {
                if (itemstack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return (ItemStack)this.itemStacks.get(0);
        }

        public ItemStack m_7407_(int slot, int p_70298_2_) {
            return ContainerHelper.m_18966_(this.itemStacks, (int)0);
        }

        public ItemStack m_8016_(int slot) {
            return ContainerHelper.m_18966_(this.itemStacks, (int)0);
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.itemStacks.set(0, (Object)stack);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            this.itemStacks.clear();
        }
    }
}

