/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.item;

import com.mrbysco.enhancedfarming.init.FarmingActions;
import com.mrbysco.enhancedfarming.init.FarmingLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;

public class RakeToolItem
extends DiggerItem {
    private final int dropModifier;

    public RakeToolItem(Tier itemTier, int attackDamage, float attackSpeed, int dropModifier, Item.Properties properties) {
        super((float)attackDamage, attackSpeed, itemTier, (Tag)BlockTags.f_144283_, properties);
        this.dropModifier = dropModifier;
    }

    public void dropSeedsWithChance(ItemStack itemstack, Level worldIn, BlockPos pos) {
        if (!worldIn.f_46443_ && worldIn.f_46441_.nextInt(30 / this.dropModifier) == 0 && worldIn.m_142572_() != null) {
            LootTable table = worldIn.m_142572_().m_129898_().m_79217_(FarmingLootTables.GAMEPLAY_RAKE_DROPS);
            LootContext.Builder context = new LootContext.Builder((ServerLevel)worldIn).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)itemstack).m_78977_(worldIn.f_46441_);
            table.m_79129_(context.m_78975_(LootContextParamSets.f_81410_)).forEach(stack -> worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.2, (double)pos.m_123343_(), stack)));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockState modifiedState = blockstate.getToolModifiedState(level, blockpos, player, context.m_43722_(), FarmingActions.RAKE_GATHER);
        BlockState finalState = null;
        if (modifiedState != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            finalState = modifiedState;
        }
        if (finalState != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, finalState, 11);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, thePlayer -> thePlayer.m_21190_(context.m_43724_()));
                    this.dropSeedsWithChance(context.m_43722_(), level, blockpos);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return FarmingActions.DEFAULT_RAKE_ACTIONS.contains(toolAction);
    }
}

