/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.sound.PositionedSound;
import team.creative.enhancedvisuals.client.sound.TickedSound;

public class VisualHandler
implements ICreativeConfig {
    @CreativeConfig
    public boolean enabled = true;
    @CreativeConfig
    @CreativeConfig.DecimalRange(max=1.0, min=0.0)
    public float opacity = 1.0f;

    public void configured(Dist side) {
    }

    public void tick(@Nullable Player player) {
    }

    public boolean isEnabled(@Nullable Player player) {
        return this.enabled && this.opacity > 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location) {
        this.playSound(location, null, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, BlockPos pos) {
        this.playSound(location, pos, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, float volume) {
        this.playSound(location, null, volume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, BlockPos pos, float volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        if (pos != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PositionedSound(location, SoundSource.MASTER, volume, 1.0f, pos));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PositionedSound(location, SoundSource.MASTER, volume, 1.0f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSoundFadeOut(ResourceLocation location, BlockPos pos, DecimalCurve volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        if (pos != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TickedSound(location, SoundSource.MASTER, 1.0f, pos, volume));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TickedSound(location, SoundSource.MASTER, 1.0f, volume));
        }
    }
}

