/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.render.TextureCache;

public abstract class VisualTypeTexture
extends VisualType {
    @CreativeConfig
    public int animationSpeed;
    public String domain;
    @OnlyIn(value=Dist.CLIENT)
    public TextureCache[] resources;
    @OnlyIn(value=Dist.CLIENT)
    public Dimension dimension;

    public VisualTypeTexture(VisualCategory category, String name, String domain, int animationSpeed) {
        super(name, category);
        this.domain = domain;
        this.animationSpeed = animationSpeed;
    }

    public VisualTypeTexture(VisualCategory category, String name, int animationSpeed) {
        this(category, name, null, animationSpeed);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadResources(ResourceManager manager) {
        String baseLocation = "visuals/" + this.cat.name() + "/" + this.name + "/" + this.name;
        ArrayList<TextureCache> caches = new ArrayList<TextureCache>();
        int i = 0;
        TextureCache resource = null;
        String domain = this.domain == null ? "enhancedvisuals" : this.domain;
        try {
            while ((resource = TextureCache.parse(manager, domain, baseLocation + i)) != null) {
                if (i == 0) {
                    BufferedImage image = ImageIO.read(manager.m_142591_(resource.getFirst()).m_6679_());
                    this.dimension = new Dimension(image.getWidth(), image.getHeight());
                }
                caches.add(resource);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resources = caches.toArray(new TextureCache[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.LOGGER.warn("Could not find any resources for '" + this.name + "'!");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVariantAmount() {
        return this.resources.length;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getResource(Visual visual) {
        if (this.animationSpeed > 0) {
            long time = Math.abs(System.nanoTime() / 3000000L / (long)this.animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)].getResource();
        }
        return this.resources[visual.variant].getResource();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(VisualHandler handler, Visual visual, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource(visual));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder renderer = tessellator.m_85915_();
        int red = visual.color != null ? visual.color.getRed() : 255;
        int green = visual.color != null ? visual.color.getGreen() : 255;
        int blue = visual.color != null ? visual.color.getBlue() : 255;
        double z = -90.0;
        int width = visual.getWidth(screenWidth);
        int height = visual.getHeight(screenHeight);
        float opacity = visual.getOpacity();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        renderer.m_5483_(0.0, (double)height, z).m_7421_(0.0f, 1.0f).m_6122_(red, green, blue, (int)(opacity * 255.0f)).m_5752_();
        renderer.m_5483_((double)width, (double)height, z).m_7421_(1.0f, 1.0f).m_6122_(red, green, blue, (int)(opacity * 255.0f)).m_5752_();
        renderer.m_5483_((double)width, 0.0, z).m_7421_(1.0f, 0.0f).m_6122_(red, green, blue, (int)(opacity * 255.0f)).m_5752_();
        renderer.m_5483_(0.0, 0.0, z).m_7421_(0.0f, 0.0f).m_6122_(red, green, blue, (int)(opacity * 255.0f)).m_5752_();
        tessellator.m_85914_();
    }

    @Override
    public int getWidth(int screenWidth) {
        return this.dimension.width;
    }

    @Override
    public int getHeight(int screenHeight) {
        return this.dimension.height;
    }
}

