/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class EVRenderer {
    private static Minecraft mc = Minecraft.m_91087_();
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EVClient.shouldRender()) {
            if (reloadResources) {
                for (VisualType type : VisualType.getTypes()) {
                    type.loadResources(mc.m_91098_());
                }
                reloadResources = false;
            }
            if (!(EVRenderer.mc.f_91080_ instanceof DeathScreen)) {
                if (EVRenderer.mc.f_91074_ != null && EVRenderer.mc.f_91074_.f_20917_ > 0 && EVRenderer.mc.f_91074_.f_20916_ == EVRenderer.mc.f_91074_.f_20917_) {
                    VisualHandlers.DAMAGE.clientHurt();
                }
                if (EVRenderer.mc.m_91385_().f_83915_ != framebufferWidth || EVRenderer.mc.m_91385_().f_83916_ != framebufferHeight) {
                    for (VisualType type : VisualType.getTypes()) {
                        type.resize(mc.m_91385_());
                    }
                    framebufferWidth = EVRenderer.mc.m_91385_().f_83915_;
                    framebufferHeight = EVRenderer.mc.m_91385_().f_83916_;
                }
                int screenWidth = mc.m_91268_().m_85445_();
                int screenHeight = mc.m_91268_().m_85446_();
                TextureManager manager = mc.m_91097_();
                float partialTicks = event.renderTickTime;
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)((float)((double)mc.m_91268_().m_85441_() / mc.m_91268_().m_85449_())), (float)0.0f, (float)((float)((double)mc.m_91268_().m_85442_() / mc.m_91268_().m_85449_())), (float)1000.0f, (float)3000.0f);
                RenderSystem.m_157425_((Matrix4f)matrix4f);
                PoseStack stack = RenderSystem.m_157191_();
                stack.m_166856_();
                stack.m_85837_(0.0, 0.0, -2000.0);
                RenderSystem.m_157182_();
                Lighting.m_84931_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69465_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69478_();
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.overlay), manager, screenWidth, screenHeight, partialTicks);
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.particle), manager, screenWidth, screenHeight, partialTicks);
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                RenderSystem.m_69493_();
                RenderSystem.m_157423_();
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.shader), manager, screenWidth, screenHeight, partialTicks);
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                mc.m_91385_().m_83947_(true);
                RenderSystem.m_157182_();
                lastRenderedMessage = null;
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = EnhancedVisuals.MESSAGES.pickRandomDeathMessage();
                }
                if (lastRenderedMessage != null) {
                    EVRenderer.mc.f_91062_.m_92750_(new PoseStack(), "\"" + lastRenderedMessage + "\"", (float)(EVRenderer.mc.f_91080_.f_96543_ / 2 - EVRenderer.mc.f_91062_.m_92895_(lastRenderedMessage) / 2), 114.0f, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderVisuals(PoseStack stack, Collection<Visual> visuals, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                stack.m_85836_();
                RenderSystem.m_157182_();
                visual.render(stack, manager, screenWidth, screenHeight, partialTicks);
                stack.m_85849_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reloadResources = false;
    }
}

