/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import team.creative.enhancedvisuals.client.render.TextureCacheAnimation;
import team.creative.enhancedvisuals.client.render.TextureCacheSimple;

public abstract class TextureCache {
    public abstract ResourceLocation getFirst();

    public abstract ResourceLocation getResource();

    public static TextureCache parse(ResourceManager manager, String domain, String baseLocation) {
        try {
            ResourceLocation location = null;
            int i = 0;
            Resource resource = null;
            ArrayList<ResourceLocation> locations = null;
            try {
                while ((resource = manager.m_142591_(location = new ResourceLocation(domain, baseLocation + "-" + i + ".png"))) != null) {
                    if (locations == null) {
                        locations = new ArrayList<ResourceLocation>();
                    }
                    locations.add(location);
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (locations != null) {
                int animationSpeed = 1;
                try {
                    resource = manager.m_142591_(new ResourceLocation(domain, baseLocation + ".ani"));
                    if (resource != null) {
                        try {
                            animationSpeed = Integer.parseInt(new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new TextureCacheAnimation(locations.toArray(new ResourceLocation[locations.size()]), animationSpeed);
            }
            location = new ResourceLocation(domain, baseLocation + ".png");
            if (manager.m_142591_(location) != null) {
                return new TextureCacheSimple(location);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

