/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.sound;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;

@OnlyIn(value=Dist.CLIENT)
public class SoundMuteHandler {
    private static Method calculateVolumeMethod = ObfuscationReflectionHelper.findMethod(SoundEngine.class, (String)"m_120327_", (Class[])new Class[]{SoundInstance.class});
    public static boolean isMuting = false;
    public static SoundEngine engine;
    public static SoundManager manager;
    public static DecimalCurve muteGraph;
    public static int timeTick;
    private static Field playingSoundsChannelField;

    public static void tick() {
        if (isMuting) {
            double factor = muteGraph.valueAt((double)timeTick);
            if (factor <= 0.0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.setMuteVolume((float)(1.0 - factor));
                ++timeTick;
            }
        }
    }

    public static float getClampedVolume(float volume) {
        return volume * (isMuting ? (float)(1.0 - muteGraph.valueAt((double)timeTick)) : 1.0f);
    }

    public static Map<SoundInstance, ChannelAccess.ChannelHandle> getSounds() {
        try {
            return (Map)playingSoundsChannelField.get(engine);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setMuteVolume(float muteVolume) {
        if (!isMuting) {
            return;
        }
        SoundMuteHandler.getSounds().forEach((p_217926_1_, p_217926_2_) -> {
            try {
                float f = ((Float)calculateVolumeMethod.invoke((Object)engine, p_217926_1_)).floatValue();
                p_217926_2_.m_120154_(p_217923_1_ -> p_217923_1_.m_83666_(f));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean startMuting(DecimalCurve muteGraph) {
        if (engine == null) {
            manager = Minecraft.m_91087_().m_91106_();
            engine = (SoundEngine)ObfuscationReflectionHelper.getPrivateValue(SoundManager.class, (Object)manager, (String)"f_120349_");
        }
        if (isMuting && SoundMuteHandler.muteGraph.valueAt((double)timeTick) > muteGraph.valueAt(0.0)) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            SoundMuteHandler.tick();
            return true;
        }
        if (!isMuting) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            isMuting = true;
            SoundMuteHandler.tick();
            return true;
        }
        return false;
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteVolume(1.0f);
        isMuting = false;
    }

    static {
        timeTick = 0;
        playingSoundsChannelField = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"f_120226_");
    }
}

