/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockBakedItemModel;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledBlockTileRenderer;
import com.supermartijn642.entangled.EntangledConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ClientRegistry.bindTileEntitySpecialRenderer(EntangledBlockTile.class, (TileEntityRenderer)new EntangledBlockTileRenderer());
    }

    public static String translate(String key, Object ... arguments) {
        return I18n.func_135052_a((String)key, (Object[])arguments);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("entangled", "block"), "inventory");
        IBakedModel model = (IBakedModel)e.getModelRegistry().get(location);
        if (model != null) {
            e.getModelRegistry().put(location, new EntangledBlockBakedItemModel(model));
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onDrawPlayerEvent(RenderWorldLastEvent e) {
            ItemStack stack = ClientUtils.getPlayer().func_184586_b(Hand.MAIN_HAND);
            if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() == Entangled.block && stack.func_77942_o() && stack.func_196082_o().func_74764_b("tileData")) {
                CompoundNBT compound = stack.func_196082_o().func_74775_l("tileData");
                ClientWorld world = ClientUtils.getMinecraft().field_71441_e;
                if (compound.func_74767_n("bound") && compound.func_74762_e("dimension") == world.func_201675_m().func_186058_p().func_186068_a()) {
                    BlockPos pos = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
                    Events.renderHighlight(ClientUtils.getMinecraft().func_175598_ae().field_217783_c, (World)world, pos, 0.3372549f, 0.0f, 0.6117647f);
                }
            } else if (stack.func_77973_b() == Entangled.item) {
                CompoundNBT compound = stack.func_196082_o();
                ClientWorld world = ClientUtils.getMinecraft().field_71441_e;
                if (compound.func_74767_n("bound") && compound.func_74762_e("dimension") == world.func_201675_m().func_186058_p().func_186068_a()) {
                    BlockPos pos = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
                    Events.renderHighlight(ClientUtils.getMinecraft().func_175598_ae().field_217783_c, (World)world, pos, 0.92156863f, 0.8235294f, 0.20392157f);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockHighlight(DrawBlockHighlightEvent.HighlightBlock e) {
            if (!EntangledConfig.renderBlockHighlight.get().booleanValue() || e.getTarget().func_216350_a() == null) {
                return;
            }
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            TileEntity tile = world.func_175625_s(e.getTarget().func_216350_a());
            if (tile instanceof EntangledBlockTile && ((EntangledBlockTile)tile).isBound() && ((EntangledBlockTile)tile).getBoundDimension() == world.func_201675_m().func_186058_p().func_186068_a()) {
                Events.renderHighlight(e.getInfo(), (World)world, ((EntangledBlockTile)tile).getBoundBlockPos(), 0.3372549f, 0.0f, 0.6117647f);
            }
        }

        private static void renderHighlight(ActiveRenderInfo info, World world, BlockPos pos, float red, float green, float blue) {
            GlStateManager.pushMatrix();
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            GlStateManager.disableBlend();
            GlStateManager.disableDepthTest();
            Vec3d playerPos = info.func_216785_c();
            GlStateManager.translated((double)(-playerPos.field_72450_a), (double)(-playerPos.field_72448_b), (double)(-playerPos.field_72449_c));
            VoxelShape shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
            Events.drawShape(shape, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), red, green, blue, 1.0f);
            GlStateManager.popMatrix();
            GlStateManager.enableTexture();
            GlStateManager.enableDepthTest();
        }

        private static void drawShape(VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            shapeIn.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
                bufferbuilder.func_181662_b(x1 + xIn, y1 + yIn, z1 + zIn).func_181666_a(red, green, blue, alpha).func_181675_d();
                bufferbuilder.func_181662_b(x2 + xIn, y2 + yIn, z2 + zIn).func_181666_a(red, green, blue, alpha).func_181675_d();
            });
            tessellator.func_78381_a();
        }
    }
}

