/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ToolType;

public class EntangledBlock
extends BaseBlock {
    public static final BooleanProperty ON = BooleanProperty.func_177716_a((String)"on");

    public EntangledBlock() {
        super("block", true, Block.Properties.func_200945_a((Material)new Material.Builder(MaterialColor.field_151650_B).func_200508_c().func_200506_i()).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af() && stack.func_190926_b() && ((Boolean)state.func_177229_b((IProperty)ON)).booleanValue()) {
            ((EntangledBlockTile)worldIn.func_175625_s(pos)).bind(null, 0);
            playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.unbind", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        } else if (stack.func_77973_b() == Entangled.item) {
            CompoundNBT compound = stack.func_77978_p();
            if (compound == null || !compound.func_74767_n("bound")) {
                playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.no_selection", new Object[0]).func_211708_a(TextFormatting.RED));
            } else {
                BlockPos pos2 = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
                if (pos2.equals((Object)pos)) {
                    playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.self", new Object[0]).func_211708_a(TextFormatting.RED));
                } else {
                    if (!((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)ON)).booleanValue()) {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ON, (Comparable)Boolean.valueOf(true)));
                    }
                    EntangledBlockTile tile = (EntangledBlockTile)worldIn.func_175625_s(pos);
                    if (compound.func_74762_e("dimension") == worldIn.func_201675_m().func_186058_p().func_186068_a()) {
                        if (EntangledConfig.maxDistance.get() == -1 || pos.func_218141_a((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                            tile.bind(pos2, compound.func_74762_e("dimension"));
                            playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.bind", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                        } else {
                            playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.too_far", new Object[0]).func_211708_a(TextFormatting.RED));
                        }
                    } else if (EntangledConfig.allowDimensional.get().booleanValue()) {
                        tile.bind(pos2, compound.func_74762_e("dimension"));
                        playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.bind", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                    } else {
                        playerIn.func_145747_a(new TranslationTextComponent("entangled.entangled_block.wrong_dimension", new Object[0]).func_211708_a(TextFormatting.RED));
                    }
                }
            }
            return true;
        }
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EntangledBlockTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ON});
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)ON) != false ? VoxelShapes.func_197880_a() : VoxelShapes.func_197868_b();
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        tooltip.add(new TranslationTextComponent("entangled.entangled_block.info." + key, new Object[]{EntangledConfig.maxDistance.get()}).func_211708_a(TextFormatting.AQUA));
        CompoundNBT tag = stack.func_196082_o().func_74775_l("tileData");
        if (tag.func_74764_b("bound") && tag.func_74767_n("bound")) {
            int x = tag.func_74762_e("boundx");
            int y = tag.func_74762_e("boundy");
            int z = tag.func_74762_e("boundz");
            String dimension = DimensionType.func_186069_a((int)tag.func_74762_e("dimension")).getRegistryName().func_110623_a();
            dimension = Character.toUpperCase(dimension.charAt(0)) + dimension.substring(1);
            ITextComponent name = Block.func_196257_b((int)tag.func_74762_e("blockstate")).func_177230_c().func_200291_n();
            tooltip.add(new TranslationTextComponent("entangled.entangled_block.info.bound", new Object[]{name, x, y, z, dimension}).func_211708_a(TextFormatting.YELLOW));
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        CompoundNBT compound = stack.func_196082_o().func_74775_l("tileData");
        if (compound.func_74767_n("bound")) {
            PlayerEntity player = context.func_195999_j();
            BlockPos pos = context.func_195995_a();
            BlockPos pos2 = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
            if (compound.func_74762_e("dimension") == context.func_195991_k().func_201675_m().func_186058_p().func_186068_a()) {
                if (EntangledConfig.maxDistance.get() >= 0 && !pos.func_218141_a((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                    if (player != null && !context.func_195991_k().field_72995_K) {
                        player.func_145747_a(new TranslationTextComponent("entangled.entangled_block.too_far", new Object[0]).func_211708_a(TextFormatting.RED));
                    }
                    return null;
                }
            } else if (!EntangledConfig.allowDimensional.get().booleanValue()) {
                if (player != null && !context.func_195991_k().field_72995_K) {
                    player.func_145747_a(new TranslationTextComponent("entangled.entangled_block.wrong_dimension", new Object[0]).func_211708_a(TextFormatting.RED));
                }
                return null;
            }
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)ON, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P();
    }
}

