/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EntangledBlockTile
extends BaseTileEntity
implements ITickableTileEntity {
    private boolean bound = false;
    private BlockPos pos;
    private int dimension;
    private BlockState blockState;
    private BlockState lastBlockState;

    public EntangledBlockTile() {
        super(Entangled.tile);
    }

    public void func_73660_a() {
        ServerWorld world;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bound && this.pos != null && (world = DimensionManager.getWorld((MinecraftServer)this.field_145850_b.func_73046_m(), (DimensionType)DimensionType.func_186069_a((int)this.dimension), (boolean)true, (boolean)false)) != null && (world.isAreaLoaded(this.pos, 1) || this.blockState == null)) {
            this.blockState = world.func_180495_p(this.pos);
            if (this.blockState != this.lastBlockState) {
                this.lastBlockState = this.blockState;
                this.dataChanged();
            }
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    @Nullable
    public BlockPos getBoundBlockPos() {
        return this.pos;
    }

    public int getBoundDimension() {
        return this.dimension;
    }

    public BlockState getBoundBlockState() {
        return this.blockState;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            TileEntity tile;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.func_201675_m().func_186058_p().func_186068_a() != this.dimension) {
                return LazyOptional.empty();
            }
            World world = this.getDimension();
            if (world != null && this.checkTile(tile = world.func_175625_s(this.pos))) {
                return tile.getCapability(capability);
            }
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            TileEntity tile;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.func_201675_m().func_186058_p().func_186068_a() != this.dimension) {
                return LazyOptional.empty();
            }
            World world = this.getDimension();
            if (world != null && this.checkTile(tile = world.func_175625_s(this.pos))) {
                return tile.getCapability(capability, facing);
            }
        }
        return LazyOptional.empty();
    }

    public boolean bind(BlockPos pos, int dimension) {
        if (!this.canBindTo(pos, dimension)) {
            return false;
        }
        this.pos = pos == null ? null : new BlockPos((Vec3i)pos);
        this.dimension = dimension;
        this.bound = pos != null;
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        this.dataChanged();
        return true;
    }

    public boolean canBindTo(BlockPos pos, int dimension) {
        return pos == null && dimension == 0 || dimension == this.field_145850_b.func_201675_m().func_186058_p().func_186068_a() ? EntangledConfig.maxDistance.get() == -1 || this.field_174879_c.func_218141_a((Vec3i)pos, (double)EntangledConfig.maxDistance.get().intValue() + 0.5) : EntangledConfig.allowDimensional.get();
    }

    private World getDimension() {
        return this.field_145850_b.field_72995_K ? (this.field_145850_b.func_201675_m().func_186058_p().func_186068_a() == this.dimension ? this.field_145850_b : null) : DimensionManager.getWorld((MinecraftServer)this.field_145850_b.func_73046_m(), (DimensionType)DimensionType.func_186069_a((int)this.dimension), (boolean)false, (boolean)false);
    }

    private boolean checkTile(TileEntity tile) {
        return tile != null && !(tile instanceof EntangledBlockTile);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("bound")) {
            CompoundNBT data = new CompoundNBT();
            data.func_74757_a("bound", compound.func_74767_n("bound"));
            data.func_74768_a("boundx", compound.func_74762_e("boundx"));
            data.func_74768_a("boundy", compound.func_74762_e("boundy"));
            data.func_74768_a("boundz", compound.func_74762_e("boundz"));
            data.func_74768_a("dimension", compound.func_74762_e("dimension"));
            compound.func_218657_a("data", (INBT)data);
        }
        super.func_145839_a(compound);
    }

    protected CompoundNBT writeData() {
        CompoundNBT compound = new CompoundNBT();
        if (this.bound) {
            compound.func_74757_a("bound", true);
            compound.func_74768_a("boundx", this.pos.func_177958_n());
            compound.func_74768_a("boundy", this.pos.func_177956_o());
            compound.func_74768_a("boundz", this.pos.func_177952_p());
            compound.func_74768_a("dimension", this.dimension);
            compound.func_74768_a("blockstate", Block.func_196246_j((BlockState)this.blockState));
        }
        return compound;
    }

    protected void readData(CompoundNBT compound) {
        this.bound = compound.func_74767_n("bound");
        if (this.bound) {
            this.pos = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
            this.dimension = compound.func_74762_e("dimension");
            this.blockState = Block.func_196257_b((int)compound.func_74762_e("blockstate"));
        }
    }
}

