/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class EntangledBlockTileRenderer
extends TileEntityRenderer<EntangledBlockTile> {
    private static int depth = 0;

    public void render(EntangledBlockTile tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!tile.isBound()) {
            return;
        }
        Block boundBlock = tile.func_145831_w().func_201675_m().func_186058_p().func_186068_a() == tile.getBoundDimension() ? tile.func_145831_w().func_180495_p(tile.getBoundBlockPos()).func_177230_c() : null;
        TileEntity boundTile = tile.func_145831_w().func_201675_m().func_186058_p().func_186068_a() == tile.getBoundDimension() ? tile.func_145831_w().func_175625_s(tile.getBoundBlockPos()) : null;
        BlockState state = tile.getBoundBlockState();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
        float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 360.0f;
        float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 360.0f;
        GlStateManager.rotatef((float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.scalef((float)0.55f, (float)0.55f, (float)0.55f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        if (boundBlock != null && boundTile != null && EntangledBlockTileRenderer.canRenderTileEntity(boundBlock.getRegistryName()) && (!(boundTile instanceof EntangledBlockTile) || depth < 10)) {
            ++depth;
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(boundTile, 0.0, 0.0, 0.0, partialTicks);
            --depth;
        }
        if (state != null && state.func_185901_i() == BlockRenderType.MODEL && EntangledBlockTileRenderer.canRenderBlock(state.func_177230_c().getRegistryName())) {
            GlStateManager.disableLighting();
            ScreenUtils.bindTexture((ResourceLocation)AtlasTexture.field_110575_b);
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                buffer.func_178969_c((double)tile.func_174877_v().func_177958_n(), (double)(tile.func_174877_v().func_177956_o() - 300), (double)tile.func_174877_v().func_177952_p());
                if (layer == BlockRenderLayer.TRANSLUCENT) {
                    GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.enableBlend();
                }
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                IModelData data = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).getModelData((IEnviromentBlockReader)tile.func_145831_w(), tile.func_174877_v(), state, (IModelData)EmptyModelData.INSTANCE);
                try {
                    BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
                    IBakedModel model = brd.func_184389_a(state);
                    brd.func_175019_b().renderModel((IEnviromentBlockReader)tile.func_145831_w(), model, state, new BlockPos(0, 300, 0), buffer, false, new Random(), 0L, data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GlStateManager.translated((double)(-tile.func_174877_v().func_177958_n()), (double)(-tile.func_174877_v().func_177956_o()), (double)(-tile.func_174877_v().func_177952_p()));
                buffer.func_178969_c(0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                if (layer != BlockRenderLayer.TRANSLUCENT) continue;
                GlStateManager.disableBlend();
            }
        }
        GlStateManager.popMatrix();
    }

    private static boolean canRenderBlock(ResourceLocation block) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(block.func_110624_b()) && !Entangled.RENDER_BLACKLISTED_BLOCKS.contains(block);
    }

    private static boolean canRenderTileEntity(ResourceLocation tile) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(tile.func_110624_b()) && !Entangled.RENDER_BLACKLISTED_TILE_ENTITIES.contains(tile);
    }
}

