/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled.integration;

import com.supermartijn642.entangled.ClientProxy;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockTile;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;

@WailaPlugin(value="entangled")
public class EntangledWailaPlugin
implements IComponentProvider,
IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, EntangledBlock.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof EntangledBlockTile) {
            if (((EntangledBlockTile)tile).isBound()) {
                BlockState boundBlockState = ((EntangledBlockTile)tile).getBoundBlockState();
                String boundBlock = boundBlockState == null ? "Block" : ClientProxy.translate(boundBlockState.func_177230_c().func_149739_a(), new Object[0]);
                BlockPos boundPos = ((EntangledBlockTile)tile).getBoundBlockPos();
                if (((EntangledBlockTile)tile).getBoundDimension() == accessor.getWorld().func_201675_m().func_186058_p().func_186068_a()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("entangled.waila.bound_same_dimension", new Object[]{boundBlock, boundPos.func_177958_n(), boundPos.func_177956_o(), boundPos.func_177952_p()}));
                } else {
                    String dimension = DimensionType.func_186069_a((int)((EntangledBlockTile)tile).getBoundDimension()).getRegistryName().func_110623_a();
                    dimension = Character.toUpperCase(dimension.charAt(0)) + dimension.substring(1);
                    tooltip.add((ITextComponent)new TranslationTextComponent("entangled.waila.bound_other_dimension", new Object[]{boundBlock, boundPos.func_177958_n(), boundPos.func_177956_o(), boundPos.func_177952_p(), dimension}));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("entangled.waila.unbound", new Object[0]));
            }
        }
    }
}

