/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.client.renderer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.userofbricks.expandedcombat.client.KeyRegistry;
import com.userofbricks.expandedcombat.client.renderer.gui.AlignmentHelper;
import com.userofbricks.expandedcombat.client.renderer.gui.HudElement;
import com.userofbricks.expandedcombat.config.ECClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class HudElementQuiverAmmo
extends HudElement {
    protected static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    public static HudElementQuiverAmmo hudActive = null;
    protected ItemStack quiver = ItemStack.f_41583_;
    protected IDynamicStackHandler arrowHandler;

    public HudElementQuiverAmmo(int elementWidth, int elementHeight, ItemStack quiverStack) {
        super(elementWidth, elementHeight);
        this.setQuiver(quiverStack);
    }

    @Override
    public void render(PoseStack matrixStack, float partialTicks) {
        String inventoryKey1;
        ItemStack beforeArrow;
        ItemStack nextArrow;
        int nextIndex;
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        if (this.quiver.m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int quiverSize = this.arrowHandler.getSlots();
        String currentAmmoStr = "";
        String beforeAmmoStr = "";
        String nextAmmoStr = "";
        int currentIndex = 0;
        int beforeIndex = quiverSize - 1;
        ItemStack currentArrow = this.arrowHandler.getStackInSlot(currentIndex).m_41777_();
        if (currentArrow.m_41619_()) {
            currentArrow = this.getNextNonEmptyStack(currentIndex, quiverSize);
            currentIndex = this.getNextNonEmptyIndex(currentIndex, quiverSize);
        }
        if ((nextIndex = currentIndex + 1) >= quiverSize) {
            nextIndex = 0;
        }
        if ((nextArrow = this.arrowHandler.getStackInSlot(nextIndex).m_41777_()).m_41619_()) {
            nextArrow = this.getNextNonEmptyStack(currentIndex, quiverSize);
            nextIndex = this.getNextNonEmptyIndex(currentIndex, quiverSize);
        }
        if (beforeIndex < 0) {
            beforeIndex = quiverSize - 1;
        }
        if ((beforeArrow = this.arrowHandler.getStackInSlot(beforeIndex).m_41777_()).m_41619_()) {
            beforeArrow = this.getPreviousNonEmptyStack(currentIndex, quiverSize);
            beforeIndex = this.getPreviousNonEmptyIndex(currentIndex, quiverSize);
        }
        currentAmmoStr = Integer.toString(currentArrow.m_41613_());
        beforeAmmoStr = Integer.toString(beforeArrow.m_41613_());
        nextAmmoStr = Integer.toString(nextArrow.m_41613_());
        int offsetX = this.getAlignedX((AlignmentHelper.Alignment)((Object)ECClientConfig.CLIENT.quiverHudAnchor.get()), (Integer)ECClientConfig.CLIENT.quiverHudOffsetX.get());
        int offsetY = this.getAlignedY((AlignmentHelper.Alignment)((Object)ECClientConfig.CLIENT.quiverHudAnchor.get()), (Integer)ECClientConfig.CLIENT.quiverHudOffsetY.get());
        if (nextIndex != currentIndex) {
            offsetX -= 10;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, (double)(mc.m_91291_().f_115093_ + 200.0f));
        MultiBufferSource.BufferSource renderBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        mc.f_91065_.m_93228_(matrixStack, offsetX, offsetY, 24, 23, 22, 22);
        mc.m_91291_().m_115203_(currentArrow, offsetX + 3, offsetY + 3);
        font.m_92811_(currentAmmoStr, (float)(offsetX + 20 - font.m_92895_(currentAmmoStr)), (float)(offsetY + 13), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
        String inventoryKey = "[" + KeyRegistry.openQuiver.m_90863_().getString().toUpperCase() + "]";
        font.m_92811_(inventoryKey, (float)(offsetX + 11) - (float)font.m_92895_(inventoryKey) / 2.0f, (float)(offsetY - 8), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
        if (beforeIndex != currentIndex && beforeIndex != nextIndex) {
            mc.m_91291_().m_115203_(beforeArrow, offsetX - 17, offsetY + 3);
            font.m_92811_(beforeAmmoStr, (float)(offsetX - font.m_92895_(beforeAmmoStr)), (float)(offsetY + 13), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
            inventoryKey1 = "[" + KeyRegistry.cycleQuiverLeft.m_90863_().getString().toUpperCase() + "]";
            font.m_92811_(inventoryKey1, (float)(offsetX - 9) - (float)font.m_92895_(inventoryKey1) / 2.0f, (float)(offsetY - 5), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
        }
        if (nextIndex != currentIndex) {
            mc.m_91291_().m_115203_(nextArrow, offsetX + 23, offsetY + 3);
            font.m_92811_(nextAmmoStr, (float)(offsetX + 40 - font.m_92895_(nextAmmoStr)), (float)(offsetY + 13), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
            inventoryKey1 = "[" + KeyRegistry.cycleQuiverRight.m_90863_().getString().toUpperCase() + "]";
            font.m_92811_(inventoryKey1, (float)(offsetX + 31) - (float)font.m_92895_(inventoryKey1) / 2.0f, (float)(offsetY - 5), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
        }
        matrixStack.m_85849_();
    }

    public void setQuiver(ItemStack quiverStack) {
        this.quiver = quiverStack;
    }

    public void setArrowHandler(IDynamicStackHandler arrowHandler) {
        this.arrowHandler = arrowHandler;
    }

    private ItemStack getNextNonEmptyStack(int currentSlot, int quiverSize) {
        for (int i = 0; i < quiverSize; ++i) {
            int newSlot = i + currentSlot + 1;
            if (newSlot >= quiverSize) {
                newSlot -= quiverSize;
            }
            if (this.arrowHandler.getStackInSlot(newSlot).m_41777_().m_41619_()) continue;
            return this.arrowHandler.getStackInSlot(newSlot).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getPreviousNonEmptyStack(int currentSlot, int quiverSize) {
        for (int i = 0; i < quiverSize; ++i) {
            int newSlot = currentSlot - 1 - i;
            if (newSlot < 0) {
                newSlot += quiverSize;
            }
            if (this.arrowHandler.getStackInSlot(newSlot).m_41777_().m_41619_()) continue;
            return this.arrowHandler.getStackInSlot(newSlot).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private int getNextNonEmptyIndex(int currentSlot, int quiverSize) {
        for (int i = 0; i < quiverSize; ++i) {
            int newSlot = i + currentSlot + 1;
            if (newSlot >= quiverSize) {
                newSlot -= quiverSize;
            }
            if (this.arrowHandler.getStackInSlot(newSlot).m_41777_().m_41619_()) continue;
            return newSlot;
        }
        return 0;
    }

    private int getPreviousNonEmptyIndex(int currentSlot, int quiverSize) {
        for (int i = 0; i < quiverSize; ++i) {
            int newSlot = currentSlot - 1 - i;
            if (newSlot < 0) {
                newSlot += quiverSize;
            }
            if (this.arrowHandler.getStackInSlot(newSlot).m_41777_().m_41619_()) continue;
            return newSlot;
        }
        return 0;
    }
}

