/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.client.renderer.gui.screen.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.userofbricks.expandedcombat.client.KeyRegistry;
import com.userofbricks.expandedcombat.client.renderer.gui.screen.inventory.CuriosButton;
import com.userofbricks.expandedcombat.client.renderer.gui.screen.inventory.QuiverButton;
import com.userofbricks.expandedcombat.config.ECClientConfig;
import com.userofbricks.expandedcombat.inventory.container.ECCuriosQuiverContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.gui.RenderButton;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;

@OnlyIn(value=Dist.CLIENT)
public class ECCuriosQuiverScreen
extends AbstractContainerScreen<ECCuriosQuiverContainer> {
    public static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/inventory.png");
    public static final ResourceLocation QUIVER_INVENTORY = new ResourceLocation("expanded_combat", "textures/gui/container/quiver.png");
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static float currentScroll;
    public boolean hasScrollBar;
    private CuriosButton buttonCurios;
    private QuiverButton buttonQuiver;
    private boolean isScrolling;
    private boolean buttonClicked;
    private boolean isRenderButtonHovered;

    public ECCuriosQuiverScreen(ECCuriosQuiverContainer curiosContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)curiosContainer, playerInventory, title);
        this.f_96546_ = true;
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCuriosButton) {
        int x = 0;
        int y = 0;
        if (isCuriosButton) {
            CuriosClientConfig.Client client = CuriosClientConfig.CLIENT;
            CuriosClientConfig.Client.ButtonCorner corner = (CuriosClientConfig.Client.ButtonCorner)client.buttonCorner.get();
            x = x + corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y = y + corner.getYoffset() + (Integer)client.buttonYOffset.get();
        } else {
            ECClientConfig.Client client = ECClientConfig.CLIENT;
            CuriosClientConfig.Client.ButtonCorner corner = (CuriosClientConfig.Client.ButtonCorner)client.buttonCorner.get();
            x = x + corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y = y + corner.getYoffset() + (Integer)client.buttonYOffset.get();
            if (CuriosClientConfig.CLIENT.buttonCorner.get() == corner) {
                switch ((CuriosClientConfig.Client.ButtonCorner)ECClientConfig.CLIENT.buttonCorner.get()) {
                    case TOP_LEFT: 
                    case TOP_RIGHT: {
                        y += 14;
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_RIGHT: {
                        y -= 14;
                    }
                }
            }
        }
        return new Tuple((Object)x, (Object)y);
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null) {
            if (this.f_96541_.f_91074_ != null) {
                this.hasScrollBar = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.f_96541_.f_91074_).map(handler -> handler.getVisibleSlots() > 8).orElse(false);
                if (this.hasScrollBar) {
                    ((ECCuriosQuiverContainer)this.f_97732_).scrollTo(currentScroll);
                }
            }
            Tuple<Integer, Integer> curiosOffsets = ECCuriosQuiverScreen.getButtonOffset(true);
            Tuple<Integer, Integer> quiverOffsets = ECCuriosQuiverScreen.getButtonOffset(false);
            this.buttonCurios = new CuriosButton(this, this.getGuiLeft() + (Integer)curiosOffsets.m_14418_(), this.f_96544_ / 2 + (Integer)curiosOffsets.m_14419_(), 14, 14, 50, 0, 14, CURIO_INVENTORY);
            this.m_142416_((GuiEventListener)this.buttonCurios);
            this.buttonQuiver = new QuiverButton(this, this.getGuiLeft() + (Integer)quiverOffsets.m_14418_(), this.f_96544_ / 2 + (Integer)quiverOffsets.m_14419_(), 14, 14, 194, 0, 14, QUIVER_INVENTORY);
            this.m_142416_((GuiEventListener)this.buttonQuiver);
            this.updateRenderButtons();
        }
    }

    public void updateRenderButtons() {
        this.f_169369_.forEach(widget -> {
            if (widget instanceof RenderButton) {
                this.m_169411_((GuiEventListener)widget);
            }
        });
        for (Slot inventorySlot : ((ECCuriosQuiverContainer)this.f_97732_).f_38839_) {
            if (!(inventorySlot instanceof CurioSlot) || inventorySlot instanceof CosmeticCurioSlot) continue;
            this.m_142416_((GuiEventListener)new RenderButton((CurioSlot)inventorySlot, this.f_97735_ + inventorySlot.f_40220_ + 11, this.f_97736_ + inventorySlot.f_40221_ - 3, 8, 8, 75, 0, 8, CURIO_INVENTORY, button -> NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketToggleRender(((CurioSlot)inventorySlot).getIdentifier(), inventorySlot.getSlotIndex()))));
        }
    }

    public void m_181908_() {
        super.m_181908_();
    }

    private boolean inScrollBar(double mouseX, double mouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i - 34;
        int l = j + 12;
        int i1 = k + 14;
        int j1 = l + 139;
        if (((ECCuriosQuiverContainer)this.f_97732_).hasCosmeticColumn()) {
            i1 -= 19;
            k -= 19;
        }
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Slot slot;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        boolean isButtonHovered = false;
        for (Widget button : this.f_169369_) {
            if (!(button instanceof RenderButton)) continue;
            ((RenderButton)button).renderButtonOverlay(matrixStack, mouseX, mouseY, partialTicks);
            if (!((RenderButton)button).m_5702_()) continue;
            isButtonHovered = true;
        }
        this.isRenderButtonHovered = isButtonHovered;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (!this.isRenderButtonHovered && clientPlayer != null && clientPlayer.f_36095_.m_142621_().m_41619_() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof CurioSlot && !slot.m_6657_()) {
            CurioSlot slotCurio = (CurioSlot)slot;
            this.m_96602_(matrixStack, (Component)new TextComponent(slotCurio.getSlotName()), mouseX, mouseY);
        }
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7025_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        LocalPlayer clientPlayer;
        Minecraft mc = this.f_96541_;
        if (mc != null && (clientPlayer = mc.f_91074_) != null && clientPlayer.f_36095_.m_142621_().m_41619_()) {
            if (this.isRenderButtonHovered) {
                this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.curios.toggle"), mouseX, mouseY);
            } else if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
                this.m_6057_(matrixStack, this.f_97734_.m_7993_(), mouseX, mouseY);
            }
        }
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (KeyRegistry.openQuiver.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                playerEntity.m_6915_();
            }
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void m_7027_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96547_.m_92889_(matrixStack, this.f_96539_, 97.0f, 6.0f, 0x404040);
        }
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)QUIVER_INVENTORY);
            int i = this.f_97735_;
            int j = this.f_97736_;
            this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
            InventoryScreen.m_98850_((int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.f_96541_.f_91074_);
            for (Slot slot : ((ECCuriosQuiverContainer)this.f_97732_).f_38839_) {
                if (!(slot instanceof CurioSlot) || !((CurioSlot)slot).getIdentifier().equals("arrows")) continue;
                int x = this.f_97735_ + slot.f_40220_ - 1;
                int y = this.f_97736_ + slot.f_40221_ - 1;
                RenderSystem.m_157456_((int)0, (ResourceLocation)QUIVER_INVENTORY);
                this.m_93228_(matrixStack, x, y, 176, 0, 18, 18);
            }
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.f_96541_.f_91074_).ifPresent(handler -> {
                int slotCount = handler.getVisibleSlots();
                if (slotCount > 0) {
                    int upperHeight = 7 + Math.min(slotCount, 9) * 18;
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)CURIO_INVENTORY);
                    int xTexOffset = 0;
                    int width = 27;
                    int xOffset = -26;
                    if (((ECCuriosQuiverContainer)this.f_97732_).hasCosmeticColumn()) {
                        xTexOffset = 92;
                        width = 46;
                        xOffset -= 19;
                    }
                    this.m_93228_(matrixStack, i + xOffset, j + 4, xTexOffset, 0, width, upperHeight);
                    if (slotCount <= 8) {
                        this.m_93228_(matrixStack, i + xOffset, j + 4 + upperHeight, xTexOffset, 151, width, 7);
                    } else {
                        this.m_93228_(matrixStack, i + xOffset - 16, j + 4, 27, 0, 23, 158);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)CREATIVE_INVENTORY_TABS);
                        this.m_93228_(matrixStack, i + xOffset - 8, j + 12 + (int)(127.0f * currentScroll), 232, 0, 12, 15);
                    }
                    for (Slot slot : ((ECCuriosQuiverContainer)this.f_97732_).f_38839_) {
                        if (!(slot instanceof CosmeticCurioSlot)) continue;
                        int x = this.f_97735_ + slot.f_40220_ - 1;
                        int y = this.f_97736_ + slot.f_40221_ - 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)CURIO_INVENTORY);
                        this.m_93228_(matrixStack, x, y, 138, 0, 18, 18);
                    }
                }
            });
        }
    }

    protected boolean m_6774_(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        if (this.isRenderButtonHovered) {
            return false;
        }
        return super.m_6774_(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.inScrollBar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (mouseReleased5 == 0) {
            this.isScrolling = false;
        }
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.m_6348_(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean m_7979_(double pMouseDragged1, double pMouseDragged3, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.isScrolling) {
            int i = this.f_97736_ + 8;
            int j = i + 148;
            currentScroll = ((float)pMouseDragged3 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            currentScroll = Mth.m_14036_((float)currentScroll, (float)0.0f, (float)1.0f);
            ((ECCuriosQuiverContainer)this.f_97732_).scrollTo(currentScroll);
            return true;
        }
        return super.m_7979_(pMouseDragged1, pMouseDragged3, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    public boolean m_6050_(double pMouseScrolled1, double pMouseScrolled3, double pMouseScrolled5) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = ((ECCuriosQuiverContainer)this.f_97732_).curiosHandler.map(ICuriosItemHandler::getVisibleSlots).orElse(1);
        currentScroll = (float)((double)currentScroll - pMouseScrolled5 / (double)i);
        currentScroll = Mth.m_14036_((float)currentScroll, (float)0.0f, (float)1.0f);
        ((ECCuriosQuiverContainer)this.f_97732_).scrollTo(currentScroll);
        return true;
    }

    private boolean needsScrollBars() {
        return ((ECCuriosQuiverContainer)this.f_97732_).canScroll();
    }

    protected void m_6597_(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.m_6597_(slotIn, slotId, mouseButton, type);
    }

    public void m_7861_() {
        super.m_7861_();
    }
}

